#include "TimeMonitor.h"

#include <time.h>
#include <iostream>
#include <iomanip>

TimeMonitor* TimeMonitor::_instance = 0;
TimeMonitor* TimeMonitor::instance() {
	if(_instance == 0) {
		_instance = new TimeMonitor();
	}
	return _instance;
}

TimeMonitor::TimeMonitor() {
	for(int i = 0; i < MetricLast; i++) {
		total[i] = 0;
		for(int j = 0; j < 5; j++) {
			window[i][j] = 0;
		}
		count[i] = 0;
		last[i] = 0;
	}

}

TimeMonitor::~TimeMonitor() {}

void TimeMonitor::tic(Metric metric) {
	last[metric] = currentTimeMillis();
}

void TimeMonitor::toc(Metric metric) {
	int delta = currentTimeMillis() - last[metric];
	total[metric] += delta;

	window[metric][count[metric] % 5] = delta;
	count[metric]++;
}

void TimeMonitor::dump(const std::string& title) {
	std::cout << "Time monitor dump (" << title << "):" << std::endl;

	int fw = 15;

	std::cout << std::setw(fw) << "Metric"
			<< std::setw(fw) << "Count"
			<< std::setw(fw) << "Average"
			<< std::setw(fw) << "Total"
			<< std::endl;

	for(int i = 0; i < MetricLast; i++) {
		switch(i) {
		case Frame:
			std::cout << std::setw(fw) << "Frame";
			break;
		case RSMCreate:
			std::cout << std::setw(fw) << "RSMCreate";
			break;
		case GVClear:
			std::cout << std::setw(fw) << "GVClear";
			break;
		case GVInject:
			std::cout << std::setw(fw) << "GVInject";
			break;
		case GVDownsample:
			std::cout << std::setw(fw) << "GVDownsample";
			break;
		case LPVClear:
			std::cout << std::setw(fw) << "LPVClear";
			break;
		case LPVInject:
			std::cout << std::setw(fw) << "LPVInject";
			break;
		case LPVPropagate:
			std::cout << std::setw(fw) << "LPVPropagate";
			break;
		case LPVDownsample:
			std::cout << std::setw(fw) << "LPVDownsample";
			break;
		case LPVMerge:
			std::cout << std::setw(fw) << "LPVMerge";
			break;
		case IXClear:
			std::cout << std::setw(fw) << "IXClear";
			break;
		}

		long avg = 0;
		if(count[i] != 0) {
			avg = total[i]/count[i];
		}

		std::cout << std::setw(fw) << count[i];
		std::cout << std::setw(fw) << avg / 1000000L;
		std::cout << std::setw(fw) << total[i] / 1000000L;
		std::cout << std::endl;
	}
	std::cout << "Dump completed." << std::endl;
}

long TimeMonitor::currentTimeMillis() {
	struct timespec tp;
	clock_gettime(CLOCK_REALTIME, &tp);
	long ms = tp.tv_nsec;
	ms += tp.tv_sec * 1000L * 1000000L;
	return ms;
}

