#ifndef TIMEMONITOR_H_
#define TIMEMONITOR_H_

#include <string>

class TimeMonitor {
public:
	enum Metric {
		Frame, RSMCreate, GVClear, GVInject, GVDownsample, IXClear, LPVClear, LPVInject, LPVDownsample, LPVPropagate, LPVMerge, MetricLast
	};

private:
	TimeMonitor();
	~TimeMonitor();

public:
	static TimeMonitor* instance();

	void tic(Metric metric);
	void toc(Metric metric);

	void dump(const std::string& title);

private:
	static TimeMonitor* _instance;

	long currentTimeMillis();

	long total[MetricLast];
	long window[MetricLast][5];
	int count[MetricLast];
	long last[MetricLast];
};

#endif /* TIMEMONITOR_H_ */
