#include "CudaVersionCheck.h"
#include "LpvStructs.h"
#include "LpvUtils.h"
#include <cstdio>

__global__ void deviceEncodeVolume(float4* from, float4* to, int3 sz) {
	int idx = blockIdx.x * blockDim.x + threadIdx.x;
	int idy = blockIdx.y * blockDim.y + threadIdx.y;
	int idz = blockIdx.z * blockDim.z + threadIdx.z;
	
	if (idx < sz.x && idy < sz.y && idz < sz.z) {
		int id = idz*sz.y*sz.x + idy*sz.x + idx;
		to[id] = make_float4(abs(from[id].x), abs(from[id].y), abs(from[id].z), abs(from[id].w));
	}
}

void cudaEncodeVolume(void* from, void* to, int size) {
	dim3 dimBlock(BLOCKSIZE, BLOCKSIZE, BLOCKSIZE);
	dim3 dimGrid(size/BLOCKSIZE+1, size/BLOCKSIZE+1, size/BLOCKSIZE+1);
	deviceEncodeVolume<<<dimGrid, dimBlock>>>((float4*)from, (float4*)to, make_int3(size));
}
