#ifndef LPVUTILS_H_
#define LPVUTILS_H_

#include "CudaVersionCheck.h"
#include "CommonStructs.h"
#include "LpvStructs.h"

#define BLOCKSIZE (4)
#define EXTRACT_DEPTH(cc)	((cc).z + (cc).y / 256.0 + (cc).x / (256.0 * 256.0) + (cc).w / (256.0 * 256.0 * 256.0))


__device__ float sign(float f);

__device__ float4 transform4x4(const float4& v, Transform transform);

__device__ float4 constructSH(float3 direction);

__device__ float4 constructSHClampedCosineLobeAroundDirection(float3 direction);

__device__ float4 rsmDepthExtractLightSpacePosition(texture<uchar4, cudaTextureType3D, cudaReadModeNormalizedFloat> rsm_depth, int3 size, float3 texCoord);

__device__ void componentwiseAtomicFloat4Add(float4& addr, float4 val);

__device__ bool isInside(const int3& size, const int3& pos);

__device__ int makeVolumeIndex(const int3& size, const int3& pos);

__device__ float3 getFaceDirection(int face);

__device__ float deg2rad(float deg);

__device__ float calculatePixelWeight(int3 ix, int3 sz);

__device__ bool isZero(const float4& v);

#endif
