#include "CudaVersionCheck.h"
#include "LpvStructs.h"
#include "LpvUtils.h"


__global__ void deviceScaleVolume(float4* v, int3 sz, float scale) {
	int idx = blockIdx.x * blockDim.x + threadIdx.x;
	int idy = blockIdx.y * blockDim.y + threadIdx.y;
	int idz = blockIdx.z * blockDim.z + threadIdx.z;
	
	if (idx < sz.x && idy < sz.y && idz < sz.z) {
		int id = idz*sz.y*sz.x + idy*sz.x + idx;
		v[id] *= scale;
	}
}

void cudaScaleVolume(void* v, int size, float scale) {
	dim3 dimBlock(BLOCKSIZE, BLOCKSIZE, BLOCKSIZE);
	dim3 dimGrid(size/BLOCKSIZE+1, size/BLOCKSIZE+1, size/BLOCKSIZE+1);
	deviceScaleVolume<<<dimGrid, dimBlock>>>((float4*)v, make_int3(size), scale);
}
