/*
 * GeometryVolume.cpp
 *
 *  Created on: Mar 15, 2012
 *      Author: dt07jo1
 */

#include "GeometryVolume.h"

#include <sstream>

namespace data {


GeometryVolume::GeometryVolume(int size, const std::string& name) : size(size) {
	size_t s = size;
	size_t i = 0;
	while(s > 1) {
		std::stringstream ss;
		ss << name << "_source_level" << i;
		source.push_back(new Volume(s, ss.str()));
		i++;
		s >>= 1;
	}
	levels = i;
	target = new Volume(size, name + "_target");
}

GeometryVolume::~GeometryVolume() {
	std::vector<Volume*>::iterator it;
	for(it = source.begin(); it != source.end(); ++it) {
		delete *it;
	}
	delete target;
}


Volume* GeometryVolume::getSource(size_t level) {
	return source[level];
}

Volume* GeometryVolume::getTarget() {
	return target;
}

int GeometryVolume::getSize(size_t level) const {
	return size >> level;
}

size_t GeometryVolume::getLevelCount() const {
	return levels;
}

} /* namespace data */
