/*
 * GeometryVolume.h
 *
 *  Created on: Mar 15, 2012
 *      Author: dt07jo1
 */

#ifndef GEOMETRYVOLUME_H_
#define GEOMETRYVOLUME_H_

#include <string>
#include "Volume.h"

namespace data {

class GeometryVolume {
public:

	GeometryVolume(int size, const std::string& name);
	~GeometryVolume();

	Volume* getSource(size_t level = 0);
	Volume* getTarget();

	int getSize(size_t level = 0) const;
	size_t getLevelCount() const;

private:
	GeometryVolume(const GeometryVolume&);
	GeometryVolume& operator=(const GeometryVolume&);

	int size;
	size_t levels;
	std::vector<Volume*> source;
	Volume* target;
};

} /* namespace data */
#endif /* GEOMETRYVOLUME_H_ */
