#include "IndexVolume.h"

#include <osgCuda/Memory>
#include <sstream>
#include <fstream>
#include <iostream>

namespace data {

IndexVolume::IndexVolume(int size, const std::string& name) : size(size), name(name) {

	int s = size;
	int i = 0;
	while(s > 1) {
		std::stringstream ss;
		ss << name << "_level" << i << "_";

		osgCompute::Memory* m = new osgCuda::Memory;
		m->setElementSize(1);
		m->setDimension(0, s * s * s);
		m->setName(ss.str() + "memory");

		memory.push_back(m);
		s >>= 1;
		i++;
	}
	levels = i;
}

IndexVolume::~IndexVolume() {}

int IndexVolume::getSize(size_t level) const {
	return size >> level;
}

int IndexVolume::getLevelCount() const {
	return levels;
}

osgCompute::Memory* IndexVolume::getMemory(size_t level) const {
	return memory[level];
}

void IndexVolume::dump(const std::string& path, const std::string& dumpId, const std::string& postfix) const {
	for(int i = 0; i < levels; i++) {
		char* data = (char*)memory[i]->map(osgCompute::MAP_HOST_SOURCE);
		int s = size >> i;

		std::stringstream ss;
		ss << path << "/" << dumpId << "-" << name << "-level" << i;
		if(!postfix.empty()) {
			ss << "-" << postfix;
		}
		ss << ".ix";
		std::ofstream out(ss.str().c_str());
		out << s << "," << s << "," << s << std::endl;

		std::cout << "Dumping " << name << " level " << i << " to " << ss.str() << std::endl;

		for(int z = 0; z < s; z++) {
			for(int y = 0; y < s; y++) {
				for(int x = 0; x < s; x++) {
					char v = data[z*s*s + y*s + x];
					out << (int)v;
					if(x != s-1) {
						out << ",";
					}
				}
				out << std::endl;
			}
		}
		out.close();
	}
}

} /* namespace data */
