/*
 * IndexVolume.h
 *
 *  Created on: Jun 19, 2012
 *      Author: dt07jo1
 */

#ifndef INDEXVOLUME_H_
#define INDEXVOLUME_H_

#include <string>
#include <vector>
#include <osgCompute/Memory>
#include <osgCuda/Texture>

namespace data {

class IndexVolume {
public:
	IndexVolume(int size, const std::string& name);
	~IndexVolume();

	osgCompute::Memory* getMemory(size_t level = 0) const;

	int getSize(size_t level = 0) const;
	int getLevelCount() const;

	void dump(const std::string& path, const std::string& dumpId, const std::string& postfix = "") const;

private:
	IndexVolume(const IndexVolume&);
	IndexVolume& operator=(const IndexVolume&);

	int size;
	int levels;
	std::vector<osgCompute::Memory*> memory;
	std::string name;
};

} /* namespace data */
#endif /* INDEXVOLUME_H_ */
