#include "LightPropagationVolume.h"

#include <iostream>
#include <sstream>

namespace data {

LightPropagationVolume::LightPropagationVolume(int size, const std::string& name) : size(size) {

	size_t s = size;
	size_t i = 0;
	while(s > 1) { // Cannot be > 0 since osgCompute doesn't allow us to create a 1x1x1 texture...
		std::stringstream ss;
		ss << name << "_level" << i << "_";
		buffers[SOURCE].push_back(new LPVComponents(s, ss.str() + "propagation0"));
		buffers[TARGET].push_back(new LPVComponents(s, ss.str() + "propagation1"));
		buffers[ACCUMULATION].push_back(new LPVComponents(s, ss.str() + "accumulated"));
		s >>= 1;
		i++;
	}
	levels = i;

	buffers[DEBUG].push_back(new LPVComponents(size, name + "_debug"));
	buffers[ENCODEDDEBUG].push_back(new LPVComponents(size, name + "_debug_encoded"));

}

LightPropagationVolume::~LightPropagationVolume() {
	for(size_t i = 0; i < LAST; ++i) {
		std::vector<LPVComponents*>::iterator it;
		for(it = buffers[i].begin(); it != buffers[i].end(); ++it) {
			delete *it;
		}
	}
}

void LightPropagationVolume::flip() {
	std::vector<LPVComponents*> temp = buffers[TARGET];
	buffers[TARGET] = buffers[SOURCE];
	buffers[SOURCE] = temp;
}

LPVComponents* LightPropagationVolume::getTargetBuffer(size_t level) {
	return buffers[TARGET][level];
}

LPVComponents* LightPropagationVolume::getSourceBuffer(size_t level) {
	return buffers[SOURCE][level];
}

LPVComponents* LightPropagationVolume::getAccumulationBuffer(size_t level) {
	return buffers[ACCUMULATION][level];
}

LPVComponents* LightPropagationVolume::getDebugBuffer(size_t level) {
	return buffers[DEBUG][level];
}

LPVComponents* LightPropagationVolume::getEncodedDebugBuffer(size_t level) {
	return buffers[ENCODEDDEBUG][level];
}

LPVComponents* LightPropagationVolume::getBuffer(BufferId bufferId, size_t level) {
	return buffers[bufferId][level];
}

int LightPropagationVolume::getSize(size_t level) const {
	return size >> level;
}

size_t LightPropagationVolume::getLevelCount() const {
	return levels;
}

} /* namespace data */
