#ifndef LIGHTPROPAGATIONVOLUME_H_
#define LIGHTPROPAGATIONVOLUME_H_

#include <string>
#include <vector>
#include "LPVComponents.h"

namespace data {

class LightPropagationVolume {
public:
	enum BufferId { SOURCE, TARGET, ACCUMULATION, DEBUG, ENCODEDDEBUG, LAST };

	LightPropagationVolume(int size, const std::string& name);
	~LightPropagationVolume();

	void flip();
	LPVComponents* getTargetBuffer(size_t level = 0);
	LPVComponents* getSourceBuffer(size_t level = 0);
	LPVComponents* getAccumulationBuffer(size_t level = 0);
	LPVComponents* getDebugBuffer(size_t level = 0);
	LPVComponents* getEncodedDebugBuffer(size_t level = 0);
	LPVComponents* getBuffer(BufferId bufferId, size_t level = 0);

	int getSize(size_t level = 0) const;
	size_t getLevelCount() const;

private:
	LightPropagationVolume(const LightPropagationVolume&);
	LightPropagationVolume& operator=(const LightPropagationVolume&);

	int size;
	size_t levels;
	std::vector<LPVComponents*> buffers[LAST];
};

} /* namespace data */
#endif /* LIGHTPROPAGATIONVOLUME_H_ */
