#include "ReflectiveShadowMap.h"

namespace data {

const std::string ReflectiveShadowMap::componentNames[3] = { "depth", "color", "normal" };

ReflectiveShadowMap::ReflectiveShadowMap(int size, int sampleSize, const std::string& name) : size(size), sampleSize(sampleSize) {
	GLenum internalFormats[] = {4, 4, 4};
	GLenum sourceFormats[] = {GL_RGBA, GL_RGBA, GL_RGBA};
	GLenum sourceTypes[] = {GL_UNSIGNED_BYTE, GL_UNSIGNED_BYTE, GL_UNSIGNED_BYTE};
	/*GLenum internalFormats[] = {GL_RGBA32F_ARB, GL_RGBA32F_ARB, GL_RGBA32F_ARB};
	GLenum sourceFormats[] = {GL_RGBA, GL_RGBA, GL_RGBA};
	GLenum sourceTypes[] = {GL_FLOAT, GL_FLOAT, GL_FLOAT};*/

	for(int i = 0; i < 3; i++) {
		textures[i] = new osgCuda::Texture3D;
		textures[i]->addIdentifier(name + "_" + componentNames[i]);
		textures[i]->setTextureSize(size, size, 6);
		textures[i]->setInternalFormat(internalFormats[i]);
		textures[i]->setSourceFormat(sourceFormats[i]);
		textures[i]->setSourceType(sourceTypes[i]);

		/*textures[i]->setFilter(osg::Texture::MIN_FILTER, osg::Texture::NEAREST);
		textures[i]->setFilter(osg::Texture::MAG_FILTER, osg::Texture::NEAREST);*/
		textures[i]->setFilter(osg::Texture::MIN_FILTER, osg::Texture::NEAREST);
		textures[i]->setFilter(osg::Texture::MAG_FILTER, osg::Texture::NEAREST);

		textures[i]->setWrap(osg::Texture::WRAP_S,osg::Texture::CLAMP_TO_EDGE);
		textures[i]->setWrap(osg::Texture::WRAP_T,osg::Texture::CLAMP_TO_EDGE);
		textures[i]->setWrap(osg::Texture::WRAP_R,osg::Texture::CLAMP_TO_EDGE);

		textures[i]->setUsage(osgCompute::GL_TARGET_COMPUTE_SOURCE);

		memory[i] = textures[i]->getMemory();
	}
}

ReflectiveShadowMap::~ReflectiveShadowMap() {}

int ReflectiveShadowMap::getSize() const {
	return size;
}

int ReflectiveShadowMap::getSampleSize() const {
	return sampleSize;
}

osgCuda::Texture3D* ReflectiveShadowMap::getTexture(Component component) {
	return textures[component];
}

osgCompute::Memory* ReflectiveShadowMap::getMemory(Component component) {
	return memory[component];
}

} /* namespace data */
