#ifndef REFLECTIVESHADOWMAP_H_
#define REFLECTIVESHADOWMAP_H_

#include <string>
#include <osgCuda/Texture>
#include <osgCompute/Memory>

namespace data {

class ReflectiveShadowMap {
public:
	enum Component {DEPTH, COLOR, NORMAL};

	static const std::string componentNames[3];

	ReflectiveShadowMap(int size, int sampleSize, const std::string& name);
	~ReflectiveShadowMap();

	int getSize() const;
	int getSampleSize() const;

	osgCuda::Texture3D* getTexture(Component component);
	osgCompute::Memory* getMemory(Component component);

private:
	int size;
	int sampleSize;

	osgCuda::Texture3D* textures[3];
	osgCompute::Memory* memory[3];
};

} /* namespace data */
#endif /* REFLECTIVESHADOWMAP_H_ */
