#ifndef VOLUME_H_
#define VOLUME_H_

#include <string>
#include <osgCompute/Memory>
#include <osgCuda/Texture>

namespace data {

class Volume {
public:
	Volume(int size, const std::string& name);
	~Volume();

	osgCuda::Texture3D* getTexture() const;
	osgCompute::Memory* getMemory() const;

	int getSize() const;

	void dump(const std::string& path, const std::string& dumpId, const std::string& postfix = "") const;

private:
	Volume(const Volume&);
	Volume& operator=(const Volume&);

	int size;
	osgCuda::Texture3D* texture;
	osgCompute::Memory* memory;
	std::string name;
};

} /* namespace data */
#endif /* VOLUME_H_ */
