#ifndef CUDAFUNCTIONS_H_
#define CUDAFUNCTIONS_H_

void cudaClearVolume(void* volume, int size);

void cudaInjectGeometry(void* target, int gvSize,
		void* rsms[3], int rsmSize, int rsmSampleSize,
		void* ix,
		void* transform, void* boundingBox, float factor);

void cudaMergeResetGeometry(void* source, void* target, int size);

void cudaInjectVolumes(void* targets[3], int lpvSize,
		void* rsms[3], int rsmSize, int rsmSampleSize,
		void* ix,
		void* transform, void* boundingBox, float factor);

void cudaPropagateVolumes(void* sources[3], void* targets[3], void* accumulated[3],
		void* geometry,
		void* ix, int size, int level,
		float factor,
		bool useOcclusion, float occlusionFactor,
		bool first);

void cudaCopyVolume(void* from, void* to, int size);

void cudaEncodeVolume(void* from, void* to, int size);

void cudaScaleVolume(void* v, int size, float scale);

void cudaResetIndices(void* indexVolume, int size, int value);

void cudaDownsampleVolumes(void* sources[3], void* targets[3], void* ix, int size, int level);

void cudaDownsampleGeometry(void* source, void* target, void* ix, int size, int level);

void cudaMergeVolumes(void* source[3], void* target[3], void* ix, int size, int level);

#endif /* CUDAFUNCTIONS_H_ */
