#include "GVClearModule.h"
#include "CUDAFunctions.h"
#include <iostream>
#include "../data/Volume.h"
#include "../Defines.h"
#include "../TimeMonitor.h"

namespace modules {

GVClearModule::GVClearModule() : gv(0) {}

bool GVClearModule::init() {
	return gv &&
			osgCompute::Module::init();
}

void GVClearModule::launch() {
	if(config->getUseIndirectLightning() && config->getUseIndirectOcclusion() && (config->getUseDynamicLpvs() || hasChangedState())) {
		debug_flow_print("%s\n", "Launching GVClearModule...");
		TimeMonitor::instance()->tic(TimeMonitor::GVClear);
		data::Volume* v = gv->getSource();
		cudaClearVolume(v->getMemory()->map(osgCompute::MAP_DEVICE_TARGET), v->getSize());
		updateState();
		TimeMonitor::instance()->toc(TimeMonitor::GVClear);
	}
}

void GVClearModule::setGeometryVolume(data::GeometryVolume* gv) {
	this->gv = gv;
}

} /* namespace modules */
