#ifndef GVCLEARMODULE_H_
#define GVCLEARMODULE_H_

#include <osgCompute/Resource>
#include <osgCompute/Module>

#include "../data/GeometryVolume.h"
#include "../SceneConfig.h"

namespace modules {

class GVClearModule : public osgCompute::Module, public SceneConfigurable {
public:
	GVClearModule();
	META_Object( , GVClearModule)

	virtual bool init();
	virtual void launch();

	void setGeometryVolume(data::GeometryVolume* gv);

private:
	GVClearModule(const GVClearModule&, const osg::CopyOp&) {}
	GVClearModule(const GVClearModule&);
	~GVClearModule() {};
	GVClearModule& operator=(const GVClearModule&);

	data::GeometryVolume* gv;
};

} /* namespace modules */
#endif /* GVCLEARMODULE_H_ */
