#include "GVDebugModule.h"
#include "CUDAFunctions.h"
#include <iostream>
#include "../Defines.h"

namespace modules {

GVDebugModule::GVDebugModule() : lpv(0), gv(0) {}

bool GVDebugModule::init() {
	return lpv && gv &&
			osgCompute::Module::init();
}

void GVDebugModule::launch() {

	if(config->getUseDebugSH() && config->getDebugMode() == SceneConfig::DEBUG_GEOMETRY &&
			config->getUseIndirectLightning() && config->getUseIndirectOcclusion() && (config->getUseDynamicLpvs() || hasChangedState())) {
		debug_flow_print("%s\n", "Launching GVDebugModule...");
		int size = lpv->getSize();
		data::Volume* volume = gv->getSource();
		data::LPVComponents* debug = lpv->getDebugBuffer();
		data::LPVComponents* encoded = lpv->getEncodedDebugBuffer();
		cudaCopyVolume(
					volume->getMemory()->map(osgCompute::MAP_DEVICE_SOURCE),
					debug->getRed()->getMemory()->map(osgCompute::MAP_DEVICE_TARGET),
					lpv->getSize()
				);
		cudaEncodeVolume(
					volume->getMemory()->map(osgCompute::MAP_DEVICE_SOURCE),
					encoded->getRed()->getMemory()->map(osgCompute::MAP_DEVICE_TARGET),
					lpv->getSize()
				);

		cudaCopyVolume(
					volume->getMemory()->map(osgCompute::MAP_DEVICE_SOURCE),
					debug->getGreen()->getMemory()->map(osgCompute::MAP_DEVICE_TARGET),
					lpv->getSize()
				);
		cudaEncodeVolume(
					volume->getMemory()->map(osgCompute::MAP_DEVICE_SOURCE),
					encoded->getGreen()->getMemory()->map(osgCompute::MAP_DEVICE_TARGET),
					lpv->getSize()
				);

		cudaCopyVolume(
					volume->getMemory()->map(osgCompute::MAP_DEVICE_SOURCE),
					debug->getBlue()->getMemory()->map(osgCompute::MAP_DEVICE_TARGET),
					lpv->getSize()
				);
		cudaEncodeVolume(
					volume->getMemory()->map(osgCompute::MAP_DEVICE_SOURCE),
					encoded->getBlue()->getMemory()->map(osgCompute::MAP_DEVICE_TARGET),
					lpv->getSize()
				);
		updateState();
	}
}

void GVDebugModule::setLightPropagationVolume(data::LightPropagationVolume* lpv) {
	this->lpv = lpv;
}

void GVDebugModule::setGeometryVolume(data::GeometryVolume* gv) {
	this->gv = gv;
}


} /* namespace modules */
