#ifndef GVDEBUGMODULE_H_
#define GVDEBUGMODULE_H_

#include <osgCompute/Resource>
#include <osgCompute/Module>

#include "../data/LightPropagationVolume.h"
#include "../data/GeometryVolume.h"
#include "../SceneConfig.h"

namespace modules {

class GVDebugModule : public osgCompute::Module, public SceneConfigurable {
public:
	GVDebugModule();
	META_Object( , GVDebugModule)

	virtual bool init();
	virtual void launch();

	void setLightPropagationVolume(data::LightPropagationVolume* lpv);
	void setGeometryVolume(data::GeometryVolume* gv);

private:
	GVDebugModule(const GVDebugModule&, const osg::CopyOp&) {}
	GVDebugModule(const GVDebugModule&);
	~GVDebugModule() {};
	GVDebugModule& operator=(const GVDebugModule&);

	data::GeometryVolume* gv;
	data::LightPropagationVolume* lpv;
};

} /* namespace modules */
#endif /* GVDEBUGMODULE_H_ */
