#include "GVDownsampleModule.h"

#include "CUDAFunctions.h"
#include <iostream>
#include <fstream>
#include <sstream>
#include "../Defines.h"
#include "../TimeMonitor.h"

namespace modules {

GVDownsampleModule::GVDownsampleModule() : gv(0), ix(0) {}

bool GVDownsampleModule::init() {
	return gv && ix &&
			osgCompute::Module::init();
}

void GVDownsampleModule::launch() {
	if(config->getUseIndirectLightning() && config->getUseIndirectOcclusion() && (config->getUseDynamicLpvs() || hasChangedState())) {
		TimeMonitor::instance()->tic(TimeMonitor::GVDownsample);

		debug_flow_print("%s\n", "Launching GVDownsampleModule...");

		for(int i = 0; i < gv->getLevelCount() - 1; i++) {

			void* source = gv->getSource(i)->getMemory()->map(osgCompute::MAP_DEVICE_SOURCE);
			void* target = gv->getSource(i+1)->getMemory()->map(osgCompute::MAP_DEVICE_TARGET);

			cudaDownsampleGeometry(source, target,
					ix->getMemory(i+1)->map(osgCompute::MAP_DEVICE), ix->getSize(),
					i);
		}

		updateState();
		TimeMonitor::instance()->toc(TimeMonitor::GVDownsample);
	}
}

void GVDownsampleModule::setGeometryVolume(data::GeometryVolume* gv) {
	this->gv = gv;
}

void GVDownsampleModule::setIndexVolume(data::IndexVolume* ix) {
	this->ix = ix;
}

} /* namespace modules */
