#ifndef GVDOWNSAMPLEMODULE_H_
#define GVDOWNSAMPLEMODULE_H_

#include <osgCompute/Module>

#include "../data/GeometryVolume.h"
#include "../data/IndexVolume.h"
#include "../SceneConfig.h"

namespace modules {

class GVDownsampleModule : public osgCompute::Module, public SceneConfigurable {
public:
	GVDownsampleModule();
	META_Object( , GVDownsampleModule)

	virtual bool init();
	virtual void launch();

	void setGeometryVolume(data::GeometryVolume* gv);
	void setIndexVolume(data::IndexVolume* ix);

private:
	GVDownsampleModule(const GVDownsampleModule&, const osg::CopyOp&) {}
	GVDownsampleModule(const GVDownsampleModule&);
	~GVDownsampleModule() {};
	GVDownsampleModule& operator=(const GVDownsampleModule&);

	data::IndexVolume* ix;
	data::GeometryVolume* gv;
};

} /* namespace modules */
#endif /* LPVDOWNSAMPLEMODULE_H_ */
