#include "GVInjectModule.h"
#include "CUDAFunctions.h"
#include <iostream>
#include "../Defines.h"
#include "../TimeMonitor.h"

namespace modules {

GVInjectModule::GVInjectModule() : gv(0), rsm(0), transform(0), boundingBox(0), ix(0) {}

void GVInjectModule::acceptResource(osgCompute::Resource& resource) {
	osgCompute::Memory* memory = dynamic_cast<osgCompute::Memory*>(&resource);
	if(memory) {
		if(resource.isIdentifiedBy("bounding_box")) {
			boundingBox = memory;
		}
	}
	osgCompute::Module::acceptResource(resource);
}

void GVInjectModule::setTransform(Transform* transform) {
	this->transform = transform;
}

bool GVInjectModule::init() {
	return gv && rsm && transform && boundingBox && ix &&
			osgCompute::Module::init();
}

void GVInjectModule::launch() {
	if(config->getUseIndirectLightning() && config->getUseIndirectOcclusion() && (config->getUseDynamicLpvs() || hasChangedState())) {
		debug_flow_print("%s\n", "Launching GVInjectModule...");

		TimeMonitor::instance()->tic(TimeMonitor::GVInject);

		data::Volume* gvv = gv->getTarget();

		void* rsms[3];
		rsms[0] = rsm->getMemory(data::ReflectiveShadowMap::DEPTH)->map(osgCompute::MAP_DEVICE_ARRAY);
		rsms[1] = rsm->getMemory(data::ReflectiveShadowMap::COLOR)->map(osgCompute::MAP_DEVICE_ARRAY);
		rsms[2] = rsm->getMemory(data::ReflectiveShadowMap::NORMAL)->map(osgCompute::MAP_DEVICE_ARRAY);

		cudaInjectGeometry(gvv->getMemory()->map(osgCompute::MAP_DEVICE_TARGET), gv->getSize(),
				rsms, rsm->getSize(), rsm->getSampleSize(),
				ix->getMemory()->map(osgCompute::MAP_DEVICE_TARGET),
				transform,
				boundingBox->map(osgCompute::MAP_DEVICE_SOURCE),
				config->getGvInjectionFactor());

		cudaMergeResetGeometry(
					gv->getSource()->getMemory()->map(osgCompute::MAP_DEVICE),
					gv->getTarget()->getMemory()->map(osgCompute::MAP_DEVICE),
					gv->getSize()
				);
		updateState();
		TimeMonitor::instance()->toc(TimeMonitor::GVInject);
	}
}

void GVInjectModule::setGeometryVolume(data::GeometryVolume* gv) {
	this->gv = gv;
}

void GVInjectModule::setReflectiveShadowMap(data::ReflectiveShadowMap* rsm) {
	this->rsm = rsm;
}

void GVInjectModule::setIndexVolume(data::IndexVolume* ix) {
	this->ix = ix;
}

} /* namespace modules */
