#ifndef GVINJECTMODULE_H_
#define GVINJECTMODULE_H_

#include <osgCompute/Resource>
#include <osgCompute/Module>

#include "../data/GeometryVolume.h"
#include "../data/ReflectiveShadowMap.h"
#include "../data/IndexVolume.h"
#include "../SceneConfig.h"
#include "../cuda/CommonStructs.h"


namespace modules {

class GVInjectModule : public osgCompute::Module, public SceneConfigurable {
public:
	GVInjectModule();
	META_Object( , GVInjectModule)

	virtual void acceptResource(osgCompute::Resource& resource);
	virtual bool init();
	virtual void launch();

	void setGeometryVolume(data::GeometryVolume* gv);
	void setReflectiveShadowMap(data::ReflectiveShadowMap* rsm);
	void setIndexVolume(data::IndexVolume* ix);
	void setTransform(Transform* transform);

private:
	GVInjectModule(const GVInjectModule&, const osg::CopyOp&) {}
	GVInjectModule(const GVInjectModule&);
	~GVInjectModule() {};
	GVInjectModule& operator=(const GVInjectModule&);

	Transform* transform;
	osgCompute::Memory* boundingBox;
	data::GeometryVolume* gv;
	data::ReflectiveShadowMap* rsm;
	data::IndexVolume* ix;
};

} /* namespace modules */
#endif /* GVINJECTMODULE_H_ */
