/*
 * IXClearModule.cpp
 *
 *  Created on: Jun 19, 2012
 *      Author: dt07jo1
 */

#include "IXClearModule.h"

#include "CUDAFunctions.h"
#include <iostream>
#include "../Defines.h"
#include "../TimeMonitor.h"

namespace modules {

IXClearModule::IXClearModule() : ix(0), initialValue(0) {}

bool IXClearModule::init() {
	return ix &&
			osgCompute::Module::init();
}

void IXClearModule::launch() {

	if(config->getUseIndirectLightning() && (config->getUseDynamicLpvs() || hasChangedState())) {

		debug_flow_print("%s\n", "Launching IXClearModule...");

		if(hasRequestedDump()) {
			ix->dump("dumps", getDumpId());
			updateDump();
			std::cout << "Index volume dumped..." << std::endl;
		}

		TimeMonitor::instance()->tic(TimeMonitor::IXClear);
		for(int i = 0; i < ix->getLevelCount(); i++) {
			cudaResetIndices(ix->getMemory(i)->map(osgCompute::MAP_DEVICE_TARGET), ix->getSize(i), initialValue);
			debug_flow_print("    * Clearing index volume level %d of size %d to value %d.\n", i, ix->getSize(i), initialValue);
		}

		updateState();
		TimeMonitor::instance()->toc(TimeMonitor::IXClear);
	}
}

void IXClearModule::setIndexVolume(data::IndexVolume* ix) {
	this->ix = ix;
}

void IXClearModule::setInitialValue(int value) {
	this->initialValue = value;
}

} /* namespace modules */
