/*
 * IXClearModule.h
 *
 *  Created on: Jun 19, 2012
 *      Author: dt07jo1
 */

#ifndef IXCLEARMODULE_H_
#define IXCLEARMODULE_H_

#include <osgCompute/Resource>
#include <osgCompute/Module>

#include "../data/IndexVolume.h"
#include "../SceneConfig.h"

namespace modules {

class IXClearModule : public osgCompute::Module, public SceneConfigurable {
public:
	IXClearModule();
	META_Object( , IXClearModule)

	virtual bool init();
	virtual void launch();

	void setIndexVolume(data::IndexVolume* ix);
	void setInitialValue(int value);

private:
	IXClearModule(const IXClearModule&, const osg::CopyOp&) {}
	IXClearModule(const IXClearModule&);
	~IXClearModule() {};
	IXClearModule& operator=(const IXClearModule&);

	int initialValue;
	data::IndexVolume* ix;
};

} /* namespace modules */
#endif /* IXCLEARMODULE_H_ */
