#include "LPVClearModule.h"
#include "CUDAFunctions.h"
#include <iostream>
#include "../Defines.h"
#include "../TimeMonitor.h"

namespace modules {

LPVClearModule::LPVClearModule() : lpv(0) {}

bool LPVClearModule::init() {
	return lpv &&
			osgCompute::Module::init();
}

void LPVClearModule::launch() {
	int size = lpv->getSize();

	if(config->getUseDebugSH() && (config->getUseDynamicLpvs() || hasChangedState())) {
		debug_flow_print("%s\n", "Launching LPVClearModule (for the debug volume)...");
		data::LPVComponents* debug = lpv->getDebugBuffer();
		cudaClearVolume(debug->getRed()->getMemory()->map(osgCompute::MAP_DEVICE_TARGET), size);
		cudaClearVolume(debug->getGreen()->getMemory()->map(osgCompute::MAP_DEVICE_TARGET), size);
		cudaClearVolume(debug->getBlue()->getMemory()->map(osgCompute::MAP_DEVICE_TARGET), size);

		data::LPVComponents* encoded = lpv->getEncodedDebugBuffer();
		cudaClearVolume(encoded->getRed()->getMemory()->map(osgCompute::MAP_DEVICE_TARGET), size);
		cudaClearVolume(encoded->getGreen()->getMemory()->map(osgCompute::MAP_DEVICE_TARGET), size);
		cudaClearVolume(encoded->getBlue()->getMemory()->map(osgCompute::MAP_DEVICE_TARGET), size);
	}

	if(config->getUseIndirectLightning() && (config->getUseDynamicLpvs() || hasChangedState())) {
		debug_flow_print("%s\n", "Launching LPVClearModule...");

		TimeMonitor::instance()->tic(TimeMonitor::LPVClear);
		data::LPVComponents* target = lpv->getTargetBuffer();
		cudaClearVolume(target->getRed()->getMemory()->map(osgCompute::MAP_DEVICE_TARGET), size);
		cudaClearVolume(target->getGreen()->getMemory()->map(osgCompute::MAP_DEVICE_TARGET), size);
		cudaClearVolume(target->getBlue()->getMemory()->map(osgCompute::MAP_DEVICE_TARGET), size);

		/*data::LPVComponents* accumulation = lpv->getAccumulationBuffer();
		cudaClearVolume(accumulation->getRed()->getMemory()->map(osgCompute::MAP_DEVICE_TARGET), size);
		cudaClearVolume(accumulation->getGreen()->getMemory()->map(osgCompute::MAP_DEVICE_TARGET), size);
		cudaClearVolume(accumulation->getBlue()->getMemory()->map(osgCompute::MAP_DEVICE_TARGET), size);*/
		updateState();
		TimeMonitor::instance()->toc(TimeMonitor::LPVClear);
	}
}

void LPVClearModule::setLightPropagationVolume(data::LightPropagationVolume* lpv) {
	this->lpv = lpv;
}

} /* namespace modules */
