#ifndef LPVCLEARMODULE_H_
#define LPVCLEARMODULE_H_

#include <osgCompute/Resource>
#include <osgCompute/Module>

#include "../data/LightPropagationVolume.h"
#include "../SceneConfig.h"

namespace modules {

class LPVClearModule : public osgCompute::Module, public SceneConfigurable {
public:
	LPVClearModule();
	META_Object( , LPVClearModule)

	virtual bool init();
	virtual void launch();

	void setLightPropagationVolume(data::LightPropagationVolume* lpv);

private:
	LPVClearModule(const LPVClearModule&, const osg::CopyOp&) {}
	LPVClearModule(const LPVClearModule&);
	~LPVClearModule() {};
	LPVClearModule& operator=(const LPVClearModule&);

	data::LightPropagationVolume* lpv;
};

} /* namespace modules */
#endif /* LPVCLEARMODULE_H_ */
