#include "LPVDebugModule.h"
#include "CUDAFunctions.h"
#include <iostream>
#include "../Defines.h"

namespace modules {

LPVDebugModule::LPVDebugModule() : lpv(0), debugMode(SceneConfig::DEBUG_INJECTION), buffer(data::LightPropagationVolume::TARGET) {}

bool LPVDebugModule::init() {
	return lpv &&
			osgCompute::Module::init();
}

void LPVDebugModule::launch() {

	if(config->getUseDebugSH() && config->getDebugMode() == debugMode &&
			config->getUseIndirectLightning() && (config->getUseDynamicLpvs() || hasChangedState())) {
		debug_flow_print("%s\n", "Launching LPVDebugModule...");
		int size = lpv->getSize();
		data::LPVComponents* target = lpv->getBuffer(buffer);
		data::LPVComponents* debug = lpv->getDebugBuffer();
		data::LPVComponents* encoded = lpv->getEncodedDebugBuffer();
		cudaCopyVolume(
					target->getRed()->getMemory()->map(osgCompute::MAP_DEVICE_SOURCE),
					debug->getRed()->getMemory()->map(osgCompute::MAP_DEVICE_TARGET),
					lpv->getSize()
				);
		cudaEncodeVolume(
					target->getRed()->getMemory()->map(osgCompute::MAP_DEVICE_SOURCE),
					encoded->getRed()->getMemory()->map(osgCompute::MAP_DEVICE_TARGET),
					lpv->getSize()
				);

		cudaCopyVolume(
					target->getGreen()->getMemory()->map(osgCompute::MAP_DEVICE_SOURCE),
					debug->getGreen()->getMemory()->map(osgCompute::MAP_DEVICE_TARGET),
					lpv->getSize()
				);
		cudaEncodeVolume(
					target->getGreen()->getMemory()->map(osgCompute::MAP_DEVICE_SOURCE),
					encoded->getGreen()->getMemory()->map(osgCompute::MAP_DEVICE_TARGET),
					lpv->getSize()
				);

		cudaCopyVolume(
					target->getBlue()->getMemory()->map(osgCompute::MAP_DEVICE_SOURCE),
					debug->getBlue()->getMemory()->map(osgCompute::MAP_DEVICE_TARGET),
					lpv->getSize()
				);
		cudaEncodeVolume(
					target->getBlue()->getMemory()->map(osgCompute::MAP_DEVICE_SOURCE),
					encoded->getBlue()->getMemory()->map(osgCompute::MAP_DEVICE_TARGET),
					lpv->getSize()
				);
		updateState();
	}
}

void LPVDebugModule::setLightPropagationVolume(data::LightPropagationVolume* lpv) {
	this->lpv = lpv;
}

void LPVDebugModule::setDebugMode(SceneConfig::DebugMode debugMode) {
	this->debugMode = debugMode;
}

void LPVDebugModule::setTargetBuffer(data::LightPropagationVolume::BufferId buffer) {
	this->buffer = buffer;
}

} /* namespace modules */
