#ifndef LPVDEBUGMODULE_H_
#define LPVDEBUGMODULE_H_

#include <osgCompute/Resource>
#include <osgCompute/Module>

#include "../data/LightPropagationVolume.h"
#include "../SceneConfig.h"

namespace modules {

class LPVDebugModule : public osgCompute::Module, public SceneConfigurable {
public:
	LPVDebugModule();
	META_Object( , LPVDebugModule)

	virtual bool init();
	virtual void launch();

	void setLightPropagationVolume(data::LightPropagationVolume* lpv);
	void setDebugMode(SceneConfig::DebugMode debugMode);
	void setTargetBuffer(data::LightPropagationVolume::BufferId buffer);

private:
	LPVDebugModule(const LPVDebugModule&, const osg::CopyOp&) {}
	LPVDebugModule(const LPVDebugModule&);
	~LPVDebugModule() {};
	LPVDebugModule& operator=(const LPVDebugModule&);

	data::LightPropagationVolume* lpv;
	SceneConfig::DebugMode debugMode;
	data::LightPropagationVolume::BufferId buffer;
};

} /* namespace modules */
#endif /* LPVDEBUGMODULE_H_ */
