#include "LPVDownsampleModule.h"

#include "CUDAFunctions.h"
#include <iostream>
#include <fstream>
#include <sstream>
#include "../Defines.h"
#include "../TimeMonitor.h"

namespace modules {

LPVDownsampleModule::LPVDownsampleModule() : lpv(0), ix(0) {}

bool LPVDownsampleModule::init() {
	return lpv && ix &&
			osgCompute::Module::init();
}

void LPVDownsampleModule::launch() {
	if(config->getUseIndirectLightning() && (config->getUseDynamicLpvs() || hasChangedState())) {
		TimeMonitor::instance()->tic(TimeMonitor::LPVDownsample);

		debug_flow_print("%s\n", "Launching LPVDownsampleModule...");

		for(int i = 0; i < lpv->getLevelCount() - 1; i++) {
			void* sources[3];
			sources[0] = lpv->getTargetBuffer(i)->getRed()->getMemory()->map(osgCompute::MAP_DEVICE_SOURCE);
			sources[1] = lpv->getTargetBuffer(i)->getGreen()->getMemory()->map(osgCompute::MAP_DEVICE_SOURCE);
			sources[2] = lpv->getTargetBuffer(i)->getBlue()->getMemory()->map(osgCompute::MAP_DEVICE_SOURCE);

			void* targets[3];
			targets[0] = lpv->getTargetBuffer(i + 1)->getRed()->getMemory()->map(osgCompute::MAP_DEVICE_TARGET);
			targets[1] = lpv->getTargetBuffer(i + 1)->getGreen()->getMemory()->map(osgCompute::MAP_DEVICE_TARGET);
			targets[2] = lpv->getTargetBuffer(i + 1)->getBlue()->getMemory()->map(osgCompute::MAP_DEVICE_TARGET);

			cudaDownsampleVolumes(sources, targets,
					ix->getMemory(i + 1)->map(osgCompute::MAP_DEVICE), ix->getSize(),
					i);
		}

		updateState();
		TimeMonitor::instance()->toc(TimeMonitor::LPVDownsample);

		/*if(hasRequestedDump()) {
			lpv->getTargetBuffer()->getRed()->dump("dumps", getDumpId());
			lpv->getTargetBuffer()->getGreen()->dump("dumps", getDumpId());
			lpv->getTargetBuffer()->getBlue()->dump("dumps", getDumpId());
			updateDump();
			std::cout << "Injector processed a dump..." << std::endl;
		}*/
	}
}

void LPVDownsampleModule::setLightPropagationVolume(data::LightPropagationVolume* lpv) {
	this->lpv = lpv;
}

void LPVDownsampleModule::setIndexVolume(data::IndexVolume* ix) {
	this->ix = ix;
}

} /* namespace modules */
