/*
 * LPVDownsampleModule.h
 *
 *  Created on: Jun 21, 2012
 *      Author: dt07jo1
 */

#ifndef LPVDOWNSAMPLEMODULE_H_
#define LPVDOWNSAMPLEMODULE_H_

#include <osgCompute/Module>

#include "../data/LightPropagationVolume.h"
#include "../data/IndexVolume.h"
#include "../SceneConfig.h"

namespace modules {

class LPVDownsampleModule : public osgCompute::Module, public SceneConfigurable {
public:
	LPVDownsampleModule();
	META_Object( , LPVDownsampleModule)

	virtual bool init();
	virtual void launch();

	void setLightPropagationVolume(data::LightPropagationVolume* lpv);
	void setIndexVolume(data::IndexVolume* ix);

private:
	LPVDownsampleModule(const LPVDownsampleModule&, const osg::CopyOp&) {}
	LPVDownsampleModule(const LPVDownsampleModule&);
	~LPVDownsampleModule() {};
	LPVDownsampleModule& operator=(const LPVDownsampleModule&);

	data::IndexVolume* ix;
	data::LightPropagationVolume* lpv;
};

} /* namespace modules */
#endif /* LPVDOWNSAMPLEMODULE_H_ */
