#include "LPVInjectModule.h"
#include "CUDAFunctions.h"
#include <iostream>
#include <fstream>
#include <sstream>
#include "../Defines.h"
#include "../TimeMonitor.h"

namespace modules {

LPVInjectModule::LPVInjectModule() : lpv(0), rsm(0), transform(0), boundingBox(0), ix(0) {}


void LPVInjectModule::acceptResource(osgCompute::Resource& resource) {
	osgCompute::Memory* memory = dynamic_cast<osgCompute::Memory*>(&resource);
	if(memory) {
		if(resource.isIdentifiedBy("bounding_box")) {
			boundingBox = memory;
		}
	}
	osgCompute::Module::acceptResource(resource);
}

void LPVInjectModule::setTransform(Transform* transform) {
	this->transform = transform;
}

bool LPVInjectModule::init() {
	return lpv && rsm && transform && boundingBox && ix &&
			osgCompute::Module::init();
}

void LPVInjectModule::launch() {
	if(config->getUseIndirectLightning() && (config->getUseDynamicLpvs() || hasChangedState())) {
		TimeMonitor::instance()->tic(TimeMonitor::LPVInject);

		debug_flow_print("%s\n", "Launching LPVInjectModule...");
		void* targets[3];
		targets[0] = lpv->getTargetBuffer()->getRed()->getMemory()->map(osgCompute::MAP_DEVICE_TARGET);
		targets[1] = lpv->getTargetBuffer()->getGreen()->getMemory()->map(osgCompute::MAP_DEVICE_TARGET);
		targets[2] = lpv->getTargetBuffer()->getBlue()->getMemory()->map(osgCompute::MAP_DEVICE_TARGET);

		void* rsms[3];
		rsms[0] = rsm->getMemory(data::ReflectiveShadowMap::DEPTH)->map(osgCompute::MAP_DEVICE_ARRAY);
		rsms[1] = rsm->getMemory(data::ReflectiveShadowMap::COLOR)->map(osgCompute::MAP_DEVICE_ARRAY);
		rsms[2] = rsm->getMemory(data::ReflectiveShadowMap::NORMAL)->map(osgCompute::MAP_DEVICE_ARRAY);

		cudaInjectVolumes(targets, lpv->getSize(),
				rsms, rsm->getSize(), rsm->getSampleSize(),
				ix->getMemory()->map(osgCompute::MAP_DEVICE_TARGET),
				transform,
				boundingBox->map(osgCompute::MAP_DEVICE_SOURCE),
				config->getLpvInjectionFactor());

		updateState();
		TimeMonitor::instance()->toc(TimeMonitor::LPVInject);

		if(hasRequestedDump()) {
			lpv->getTargetBuffer()->getRed()->dump("dumps", getDumpId());
			lpv->getTargetBuffer()->getGreen()->dump("dumps", getDumpId());
			lpv->getTargetBuffer()->getBlue()->dump("dumps", getDumpId());
			updateDump();
			std::cout << "Injector processed a dump..." << std::endl;
		}
	}
}

void LPVInjectModule::setLightPropagationVolume(data::LightPropagationVolume* lpv) {
	this->lpv = lpv;
}

void LPVInjectModule::setReflectiveShadowMap(data::ReflectiveShadowMap* rsm) {
	this->rsm = rsm;
}

void LPVInjectModule::setIndexVolume(data::IndexVolume* ix) {
	this->ix = ix;
}

} /* namespace modules */
