#ifndef LPVINJECTMODULE_H_
#define LPVINJECTMODULE_H_

#include <osgCompute/Resource>
#include <osgCompute/Module>

#include "../data/LightPropagationVolume.h"
#include "../data/ReflectiveShadowMap.h"
#include "../data/IndexVolume.h"
#include "../SceneConfig.h"
#include "../cuda/CommonStructs.h"

namespace modules {

class LPVInjectModule : public osgCompute::Module, public SceneConfigurable {
public:
	LPVInjectModule();
	META_Object( , LPVInjectModule)

	virtual void acceptResource(osgCompute::Resource& resource);
	virtual bool init();
	virtual void launch();

	void setLightPropagationVolume(data::LightPropagationVolume* lpv);
	void setReflectiveShadowMap(data::ReflectiveShadowMap* rsm);
	void setIndexVolume(data::IndexVolume* ix);
	void setTransform(Transform* transform);

private:
	LPVInjectModule(const LPVInjectModule&, const osg::CopyOp&) {}
	LPVInjectModule(const LPVInjectModule&);
	~LPVInjectModule() {};
	LPVInjectModule& operator=(const LPVInjectModule&);

	Transform* transform;
	osgCompute::Memory* boundingBox;
	data::IndexVolume* ix;
	data::LightPropagationVolume* lpv;
	data::ReflectiveShadowMap* rsm;
};

} /* namespace modules */
#endif /* LPVINJECTMODULE_H_ */
