#include "LPVMergeModule.h"

#include "CUDAFunctions.h"
#include <iostream>
#include "../Defines.h"
#include "../TimeMonitor.h"

namespace modules {

LPVMergeModule::LPVMergeModule() : lpv(0), ix(0) {}

bool LPVMergeModule::init() {
	return lpv && ix &&
			osgCompute::Module::init();
}

void LPVMergeModule::launch() {
	if(config->getUseIndirectLightning() && (config->getUseDynamicLpvs() || hasChangedState())) {
		debug_flow_print("%s\n", "Launching LPVMergeModule...");

		TimeMonitor::instance()->tic(TimeMonitor::LPVMerge);

		/*if(config->getLpvSampleLevel() != -1) {
			cudaResetIndices(ix->getMemory()->map(osgCompute::MAP_DEVICE_TARGET), ix->getSize(), std::min((int)lpv->getLevelCount() - 1, config->getLpvSampleLevel()));
		}*/

		for(int level = lpv->getLevelCount() - 2; level >= 0; level--) {
			void* source[3];
			source[0] = lpv->getAccumulationBuffer(level + 1)->getRed()->getMemory()->map(osgCompute::MAP_DEVICE_SOURCE);
			source[1] = lpv->getAccumulationBuffer(level + 1)->getGreen()->getMemory()->map(osgCompute::MAP_DEVICE_SOURCE);
			source[2] = lpv->getAccumulationBuffer(level + 1)->getBlue()->getMemory()->map(osgCompute::MAP_DEVICE_SOURCE);

			void* target[3];
			target[0] = lpv->getAccumulationBuffer(level)->getRed()->getMemory()->map(osgCompute::MAP_DEVICE_TARGET);
			target[1] = lpv->getAccumulationBuffer(level)->getGreen()->getMemory()->map(osgCompute::MAP_DEVICE_TARGET);
			target[2] = lpv->getAccumulationBuffer(level)->getBlue()->getMemory()->map(osgCompute::MAP_DEVICE_TARGET);

			void* indexVolume = ix->getMemory(level)->map(osgCompute::MAP_DEVICE_SOURCE);

			int size = lpv->getSize();

			cudaMergeVolumes(source, target, indexVolume, size, level);
		}
		TimeMonitor::instance()->toc(TimeMonitor::LPVMerge);

		updateState();
	}
}

void LPVMergeModule::setLightPropagationVolume(data::LightPropagationVolume* lpv) {
	this->lpv = lpv;
}

void LPVMergeModule::setIndexVolume(data::IndexVolume* ix) {
	this->ix = ix;
}

} /* namespace modules */
