#ifndef LPVMERGEMODULE_H_
#define LPVMERGEMODULE_H_

#include <osgCompute/Resource>
#include <osgCompute/Module>

#include "../data/LightPropagationVolume.h"
#include "../data/IndexVolume.h"
#include "../SceneConfig.h"

namespace modules {

class LPVMergeModule : public osgCompute::Module, public SceneConfigurable {
public:
	LPVMergeModule();
	META_Object( , LPVMergeModule)

	virtual bool init();
	virtual void launch();

	void setLightPropagationVolume(data::LightPropagationVolume* lpv);
	void setIndexVolume(data::IndexVolume* ix);

private:
	LPVMergeModule(const LPVMergeModule&, const osg::CopyOp&) {};
	LPVMergeModule(const LPVMergeModule&);
	~LPVMergeModule() {};
	LPVMergeModule& operator=(const LPVMergeModule&);

	data::LightPropagationVolume* lpv;
	data::IndexVolume* ix;
};

} /* namespace modules */
#endif /* LPVMERGEMODULE_H_ */
