#include "LPVPropagateModule.h"
#include "CUDAFunctions.h"
#include <iostream>
#include "../Defines.h"
#include "../TimeMonitor.h"

namespace modules {

LPVPropagateModule::LPVPropagateModule() : lpv(0), gv(0), ix(0) {}

bool LPVPropagateModule::init() {
	return lpv && gv && ix &&
			osgCompute::Module::init();
}

void LPVPropagateModule::launch() {
	if(config->getUseIndirectLightning() && (config->getUseDynamicLpvs() || hasChangedState())) {
		debug_flow_print("%s\n", "Launching LPVPropagateModule...");

		TimeMonitor::instance()->tic(TimeMonitor::LPVPropagate);

		for(int i = 0; i < config->getLpvPropagationSteps(); i++) {
			lpv->flip();
			for(int level = 0; level < lpv->getLevelCount(); level++) {

				void* sources[3];
				sources[0] = lpv->getSourceBuffer(level)->getRed()->getMemory()->map(osgCompute::MAP_DEVICE_SOURCE);
				sources[1] = lpv->getSourceBuffer(level)->getGreen()->getMemory()->map(osgCompute::MAP_DEVICE_SOURCE);
				sources[2] = lpv->getSourceBuffer(level)->getBlue()->getMemory()->map(osgCompute::MAP_DEVICE_SOURCE);

				void* targets[3];
				targets[0] = lpv->getTargetBuffer(level)->getRed()->getMemory()->map(osgCompute::MAP_DEVICE_TARGET);
				targets[1] = lpv->getTargetBuffer(level)->getGreen()->getMemory()->map(osgCompute::MAP_DEVICE_TARGET);
				targets[2] = lpv->getTargetBuffer(level)->getBlue()->getMemory()->map(osgCompute::MAP_DEVICE_TARGET);

				void* accumulated[3];
				accumulated[0] = lpv->getAccumulationBuffer(level)->getRed()->getMemory()->map(osgCompute::MAP_DEVICE);
				accumulated[1] = lpv->getAccumulationBuffer(level)->getGreen()->getMemory()->map(osgCompute::MAP_DEVICE);
				accumulated[2] = lpv->getAccumulationBuffer(level)->getBlue()->getMemory()->map(osgCompute::MAP_DEVICE);

				void* geometry = gv->getSource(level)->getMemory()->map(osgCompute::MAP_DEVICE_SOURCE);

				int size = lpv->getSize();

				cudaPropagateVolumes(sources, targets, accumulated,
						geometry,
						ix->getMemory(level)->map(osgCompute::MAP_DEVICE),
						size, level,
						config->getLpvPropagationFactor(),
						config->getUseIndirectOcclusion(),
						config->getGvOcclusionFactor(),
						i == 0);


				if(hasRequestedDump()) {
					std::stringstream ss;
					ss << "it" << (i+1);
					ss << "level" << level;
					lpv->getTargetBuffer(level)->getRed()->dump("dumps", getDumpId(), ss.str());
					lpv->getTargetBuffer(level)->getGreen()->dump("dumps", getDumpId(), ss.str());
					lpv->getTargetBuffer(level)->getBlue()->dump("dumps", getDumpId(), ss.str());

					lpv->getAccumulationBuffer(level)->getRed()->dump("dumps", getDumpId(), ss.str());
					lpv->getAccumulationBuffer(level)->getGreen()->dump("dumps", getDumpId(), ss.str());
					lpv->getAccumulationBuffer(level)->getBlue()->dump("dumps", getDumpId(), ss.str());
				}
			}
		}
		TimeMonitor::instance()->toc(TimeMonitor::LPVPropagate);

		if(hasRequestedDump()) {
			updateDump();
		}
		updateState();
	}
}

void LPVPropagateModule::setLightPropagationVolume(data::LightPropagationVolume* lpv) {
	this->lpv = lpv;
}

void LPVPropagateModule::setGeometryVolume(data::GeometryVolume* gv) {
	this->gv = gv;
}

void LPVPropagateModule::setIndexVolume(data::IndexVolume* ix) {
	this->ix = ix;
}

} /* namespace modules */
