#ifndef LPVPROPAGATEMODULE_H_
#define LPVPROPAGATEMODULE_H_

#include <osgCompute/Resource>
#include <osgCompute/Module>

#include "../data/LightPropagationVolume.h"
#include "../data/GeometryVolume.h"
#include "../data/IndexVolume.h"
#include "../SceneConfig.h"

namespace modules {

class LPVPropagateModule : public osgCompute::Module, public SceneConfigurable {
public:
	LPVPropagateModule();
	META_Object( , LPVPropagateModule)

	virtual bool init();
	virtual void launch();

	void setLightPropagationVolume(data::LightPropagationVolume* lpv);
	void setGeometryVolume(data::GeometryVolume* gv);
	void setIndexVolume(data::IndexVolume* ix);

private:
	LPVPropagateModule(const LPVPropagateModule&, const osg::CopyOp&) {};
	LPVPropagateModule(const LPVPropagateModule&);
	~LPVPropagateModule() {};
	LPVPropagateModule& operator=(const LPVPropagateModule&);

	data::LightPropagationVolume* lpv;
	data::GeometryVolume* gv;
	data::IndexVolume* ix;
};

} /* namespace modules */
#endif /* LPVPROPAGATEMODULE_H_ */
