/*
 * Decompiled with CFR 0.152.
 */
package akuma;

import akuma.CLibrary;
import akuma.JavaVMArguments;
import com.sun.jna.StringArray;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class Daemon {
    public void all(boolean daemonize) throws Exception {
        if (this.isDaemonized()) {
            this.init();
        } else if (daemonize) {
            this.daemonize();
            System.exit(0);
        }
    }

    public boolean isDaemonized() {
        return System.getProperty(Daemon.class.getName()) != null;
    }

    public void daemonize() throws IOException {
        this.daemonize(JavaVMArguments.current());
    }

    public void daemonize(JavaVMArguments args) {
        if (this.isDaemonized()) {
            throw new IllegalStateException("Already running as a daemon");
        }
        args.setSystemProperty(Daemon.class.getName(), "daemonized");
        String exe = Daemon.getCurrentExecutable();
        StringArray sa = args.toStringArray();
        int i = CLibrary.LIBC.fork();
        if (i < 0) {
            CLibrary.LIBC.perror("initial fork failed");
            System.exit(-1);
        }
        if (i == 0) {
            CLibrary.LIBC.execv(exe, sa);
            System.err.println("exec failed");
            CLibrary.LIBC.perror("initial exec failed");
            System.exit(-1);
        }
    }

    public static void selfExec(JavaVMArguments args) {
        CLibrary.LIBC.execv(Daemon.getCurrentExecutable(), args.toStringArray());
    }

    public void init() throws Exception {
        this.init("/var/run/daemon.pid");
    }

    public void init(String pidFile) throws Exception {
        CLibrary.LIBC.setsid();
        this.closeDescriptors();
        this.chdirToRoot();
        if (pidFile != null) {
            this.writePidFile(pidFile);
        }
    }

    protected void closeDescriptors() throws IOException {
        if (!Boolean.getBoolean(Daemon.class.getName() + ".keepDescriptors")) {
            System.out.close();
            System.err.close();
            System.in.close();
        }
    }

    protected void chdirToRoot() {
        CLibrary.LIBC.chdir("/");
        System.setProperty("user.dir", "/");
    }

    protected void writePidFile(String pidFile) throws IOException {
        try {
            FileWriter fw = new FileWriter(pidFile);
            fw.write(String.valueOf(CLibrary.LIBC.getpid()));
            fw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String getCurrentExecutable() {
        int pid = CLibrary.LIBC.getpid();
        String name = "/proc/" + pid + "/exe";
        if (new File(name).exists()) {
            return name;
        }
        return System.getProperty("java.home") + "/bin/java";
    }
}

