/*
 * Decompiled with CFR 0.152.
 */
package rcon.client;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import rcon.RCONDaemon;
import rcon.client.CommandModule;
import rcon.commands.Command;
import rcon.net.RCONOutputStream;
import rcon.players.Admin;
import rcon.players.Right;

public class AdminModule
extends CommandModule {
    public AdminModule(RCONOutputStream out, RCONDaemon daemon) {
        super(out, daemon);
    }

    public void edit(Admin user, Command request) throws IOException {
        block7: {
            if (request.size() == 2) {
                try {
                    int id = request.getInt(0);
                    String guid = request.get(1);
                    Admin admin = this.daemon.getDatabase().admins.get(id);
                    if (admin == null) {
                        this.reply(request, "AdminNotFound", new String[0]);
                        break block7;
                    }
                    admin.setGuid(guid);
                    if (this.daemon.getDatabase().admins.save(admin)) {
                        this.log(user, "Edited GUID of " + admin.getUserName() + " to '" + admin.getGuid() + "'.");
                        this.reply(request, "OK", new String[0]);
                        break block7;
                    }
                    this.reply(request, "ServerError", new String[0]);
                }
                catch (NumberFormatException e) {
                    this.reply(request, "InvalidArguments", new String[0]);
                }
                catch (SQLException e) {
                    this.reply(request, "ServerError", new String[0]);
                }
            } else {
                this.reply(request, "InvalidArguments", new String[0]);
            }
        }
    }

    public void register(Admin user, Command request) throws IOException {
        block7: {
            if (request.size() == 3) {
                String guid = request.get(0);
                String username = request.get(1);
                String password = request.get(2);
                try {
                    Admin adminByGuid = this.daemon.getDatabase().admins.getByGuid(guid);
                    Admin adminByName = this.daemon.getDatabase().admins.get(username);
                    if (adminByGuid != null) {
                        this.reply(request, "GuidAlreadyExists", new String[0]);
                        break block7;
                    }
                    if (adminByName != null) {
                        this.reply(request, "NameAlreadyExists", new String[0]);
                        break block7;
                    }
                    Admin admin = new Admin(0, guid, username, password, EnumSet.noneOf(Right.class));
                    if (this.daemon.getDatabase().admins.create(admin)) {
                        this.log(user, "Registered admin '" + username + "' with GUID '" + guid + "'.");
                        this.reply(request, "OK", String.valueOf(admin.getId()));
                        break block7;
                    }
                    this.reply(request, "ServerError", new String[0]);
                }
                catch (SQLException e) {
                    this.reply(request, "ServerError", new String[0]);
                }
            } else {
                this.reply(request, "InvalidArguments", new String[0]);
            }
        }
    }

    public void setPassword(Admin user, Command request) throws IOException {
        block9: {
            if (request.size() == 2) {
                try {
                    int id = request.getInt(0);
                    String password = request.get(1);
                    Admin admin = this.daemon.getDatabase().admins.get(id);
                    if (admin == null) {
                        this.reply(request, "AdminNotFound", new String[0]);
                        break block9;
                    }
                    if (user != null && (user.getId() == admin.getId() || user.hasRight(Right.editAdmin))) {
                        admin.setPassword(password);
                        if (this.daemon.getDatabase().admins.save(admin)) {
                            this.log(user, "Changed password for '" + admin.getUserName() + "'.");
                            this.reply(request, "OK", new String[0]);
                        } else {
                            this.reply(request, "ServerError", new String[0]);
                        }
                        break block9;
                    }
                    this.reply(request, "NotAuthorized", new String[0]);
                }
                catch (NumberFormatException e) {
                    this.reply(request, "InvalidArguments", new String[0]);
                }
                catch (SQLException e) {
                    this.reply(request, "ServerError", new String[0]);
                }
            } else {
                this.reply(request, "InvalidArguments", new String[0]);
            }
        }
    }

    public void get(Admin user, Command request) throws IOException {
        block13: {
            if (request.size() == 2) {
                String method = request.get(0);
                try {
                    Admin admin = null;
                    if (method.equals("name")) {
                        String name = request.get(1);
                        admin = this.daemon.getDatabase().admins.get(name);
                    } else if (method.equals("id")) {
                        int id = request.getInt(1);
                        admin = this.daemon.getDatabase().admins.get(id);
                    } else if (method.equals("eaguid")) {
                        String guid = request.get(1);
                        admin = this.daemon.getDatabase().admins.getByGuid(guid);
                    } else {
                        this.reply(request, "InvalidMethod", new String[0]);
                    }
                    if (admin == null) {
                        this.reply(request, "AdminNotFound", new String[0]);
                        break block13;
                    }
                    EnumSet<Right> rights = admin.getRights();
                    String[] args = new String[4 + rights.size()];
                    args[0] = String.valueOf(admin.getId());
                    args[1] = admin.getGuid();
                    args[2] = admin.getUserName();
                    args[3] = String.valueOf(rights.size());
                    Iterator it = rights.iterator();
                    for (int i = 4; i < args.length; ++i) {
                        args[i] = ((Right)((Object)it.next())).name();
                    }
                    this.reply(request, "OK", args);
                }
                catch (NumberFormatException e) {
                    this.reply(request, "InvalidArguments", new String[0]);
                }
                catch (SQLException e) {
                    this.reply(request, "ServerError", new String[0]);
                }
            } else {
                this.reply(request, "InvalidArguments", new String[0]);
            }
        }
    }

    public void setRights(Admin user, Command request) throws IOException {
        block10: {
            if (request.size() >= 2) {
                try {
                    int adminId = request.getInt(0);
                    int rightsCount = request.getInt(1);
                    if (request.size() == 2 + rightsCount) {
                        String[] rightNames = new String[rightsCount];
                        System.arraycopy(request.getArguments(), 2, rightNames, 0, rightsCount);
                        EnumSet<Right> rights = Right.parseRights(rightNames);
                        Admin admin = this.daemon.getDatabase().admins.get(adminId);
                        if (admin == null) {
                            this.reply(request, "AdminNotFound", new String[0]);
                        } else {
                            admin.setRights(rights);
                            if (this.daemon.getDatabase().admins.save(admin)) {
                                this.log(user, "Set the rights of '" + admin.getUserName() + "' to '" + Right.toString(rights) + "'.");
                                this.reply(request, "OK", String.valueOf(admin.getRights().size()));
                            } else {
                                this.reply(request, "ServerError", new String[0]);
                            }
                        }
                        break block10;
                    }
                    this.reply(request, "InvalidArguments", new String[0]);
                }
                catch (NumberFormatException e) {
                    this.reply(request, "InvalidArguments", new String[0]);
                }
                catch (SQLException e) {
                    this.reply(request, "ServerError", new String[0]);
                }
            } else {
                this.reply(request, "InvalidArguments", new String[0]);
            }
        }
    }

    public void list(Admin user, Command request) throws IOException {
        try {
            ArrayList<Admin> admins = this.daemon.getDatabase().admins.getAll();
            String[] args = new String[1 + admins.size() * 3];
            int i = 0;
            args[i++] = String.valueOf(admins.size());
            for (Admin a : admins) {
                args[i++] = String.valueOf(a.getId());
                args[i++] = a.getGuid();
                args[i++] = a.getUserName();
            }
            this.reply(request, "OK", args);
        }
        catch (SQLException e) {
            this.reply(request, "ServerError", new String[0]);
        }
    }
}

