/*
 * Decompiled with CFR 0.152.
 */
package rcon.client;

import java.util.EnumSet;
import java.util.HashMap;
import rcon.players.Right;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ClientCommand {
    VERSION("version"),
    LOGOUT("logout"),
    QUIT("quit"),
    SHUTDOWN("shutdown", Right.shutdownDaemon, new Right[0]),
    LOGIN_HASHED("login.hashed"),
    DAEMON_STATUS("daemon.status", Right.console, new Right[0]),
    SERVER_STATUS("server.status", Right.console, new Right[0]),
    CONFIG_SET("config.set", Right.changeConfiguration, new Right[0]),
    CONFIG_GET("config.get", Right.console, new Right[0]),
    CONFIG_CLEAR("config.clear", Right.changeConfiguration, new Right[0]),
    CONFIG_LIST("config.list", Right.console, new Right[0]),
    CONFIG_ALL("config.all", Right.console, new Right[0]),
    BANS_LIST("bans.list", Right.listBans, new Right[0]),
    BANS_HISTORY("bans.history", Right.playerHistory, new Right[0]),
    BANS_REMOVE("bans.remove", Right.unban, new Right[0]),
    BANS_WARN("bans.warn", Right.kick, new Right[0]),
    BANS_KICK("bans.kick", Right.kick, new Right[0]),
    BANS_BAN("bans.ban", Right.ban, new Right[0]),
    BANS_EDIT("bans.edit", Right.unban, new Right[0]),
    BANS_GET("bans.get", Right.listBans, new Right[0]),
    ADMINS_SET_RIGHTS("admins.setRights", Right.setRights, new Right[0]),
    ADMINS_GET("admins.get", Right.console, new Right[0]),
    ADMINS_SET_PASSWORD("admins.setPassword", Right.console, new Right[0]),
    ADMINS_REGISTER("admins.register", Right.registerAdmin, new Right[0]),
    ADMINS_EDIT("admins.edit", Right.editAdmin, new Right[0]),
    ADMINS_LIST("admins.list", Right.console, new Right[0]),
    PLAYERS_LIST("players.list", Right.console, new Right[0]),
    PLAYERS_SEARCH("players.search", Right.console, new Right[0]),
    PLAYERS_YELL("players.yell", Right.yell, new Right[0]),
    PLAYERS_SAY("players.say", Right.yell, new Right[0]),
    PUNKBUSTER_EXECUTE("punkbuster.execute", Right.pbAdmin, new Right[0]),
    MESSAGES_LIST("messages.list", Right.console, new Right[0]),
    MESSAGES_ADD("messages.add", Right.editMessages, new Right[0]),
    MESSAGES_EDIT("messages.edit", Right.editMessages, new Right[0]),
    MESSAGES_REMOVE("messages.remove", Right.editMessages, new Right[0]),
    LOGS_ADMIN("logs.admin", Right.adminLogs, new Right[0]),
    LOGS_CHAT("logs.chat", Right.chatLogs, new Right[0]),
    LOGS_EVENT("logs.event", Right.eventLogs, new Right[0]),
    RESERVEDSLOTS_LOAD("reservedSlots.load", Right.reservedSlots, new Right[0]),
    RESERVEDSLOTS_SAVE("reservedSlots.save", Right.reservedSlots, new Right[0]),
    RESERVEDSLOTS_CLEAR("reservedSlots.clear", Right.reservedSlots, new Right[0]),
    RESERVEDSLOTS_LIST("reservedSlots.list", Right.console, new Right[0]),
    RESERVEDSLOTS_ADDPLAYER("reservedSlots.addPlayer", Right.reservedSlots, new Right[0]),
    RESERVEDSLOTS_REMOVEPLAYER("reservedSlots.removePlayer", Right.reservedSlots, new Right[0]);

    private static HashMap<String, ClientCommand> commands;
    private String command;
    private EnumSet<Right> rights;

    private ClientCommand(String command, EnumSet<Right> rights) {
        this.command = command;
        this.rights = rights;
    }

    private ClientCommand(String command, Right right, Right ... rights) {
        this.command = command;
        this.rights = EnumSet.of(right, rights);
    }

    private ClientCommand(String command) {
        this.command = command;
        this.rights = EnumSet.noneOf(Right.class);
    }

    public String getCommand() {
        return this.command;
    }

    public boolean hasRights(EnumSet<Right> rights) {
        return rights.containsAll(this.rights);
    }

    public static ClientCommand get(String command) {
        return commands.get(command);
    }

    static {
        commands = new HashMap();
        for (ClientCommand command : ClientCommand.values()) {
            commands.put(command.getCommand(), command);
        }
    }
}

