/*
 * Decompiled with CFR 0.152.
 */
package rcon.client.swing;

import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.EnumSet;
import rcon.Hex;
import rcon.MessageType;
import rcon.commands.ClientRequest;
import rcon.commands.Command;
import rcon.net.RCONInputStream;
import rcon.net.RCONOutputStream;
import rcon.players.Admin;
import rcon.players.Player;
import rcon.players.Punishment;
import rcon.players.PunishmentType;
import rcon.players.Right;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaemonConnection {
    private Socket socket;
    private RCONInputStream in;
    private RCONOutputStream out;
    private int seq;

    public DaemonConnection(Socket socket) throws IOException {
        this.socket = socket;
        this.seq = 1;
        this.in = new RCONInputStream(socket.getInputStream());
        this.out = new RCONOutputStream(socket.getOutputStream());
    }

    public boolean login(String username, String password) throws IOException {
        ClientRequest command = new ClientRequest("login.hashed", new String[0]);
        command.setSeq(this.seq++);
        this.out.sendCommand(command);
        Command result = this.in.readCommand();
        if (result.getName().equals("OK")) {
            String salt = result.getArguments()[0];
            String hexHash = Hex.hashPassword(password, salt);
            this.out.sendCommand(new ClientRequest("login.hashed", username, hexHash));
            result = this.in.readCommand();
            if (result.getName().equals("OK")) {
                return true;
            }
        }
        return false;
    }

    public ArrayList<Admin> getAdmins() throws IOException {
        Command response = this.request("admins.list", new String[0]);
        ArrayList<Admin> admins = new ArrayList<Admin>();
        if (response.getName().equals("OK")) {
            int i = 0;
            int amount = response.getInt(i++);
            for (int j = 0; j < amount; ++j) {
                int id = response.getInt(i++);
                String guid = response.get(i++);
                String username = response.get(i++);
                admins.add(new Admin(id, guid, username, "", EnumSet.noneOf(Right.class)));
            }
        }
        return admins;
    }

    private Command request(String command, String ... arguments) throws IOException {
        Command request = new Command(command, MessageType.client_request, this.seq++, arguments);
        this.out.sendCommand(request);
        return this.in.readCommand();
    }

    public boolean registerAdmin(Admin admin) throws IOException {
        Command response = this.request("admins.register", admin.getGuid(), admin.getUserName(), admin.getPassword());
        return response.getName().equals("OK");
    }

    public Admin getAdmin(int id) throws IOException {
        Command response = this.request("admins.get", "id", String.valueOf(id));
        if (response.getName().equals("OK")) {
            String guid = response.get(1);
            String username = response.get(2);
            int amount = response.getInt(3);
            String[] rightNames = new String[amount];
            System.arraycopy(response.getArguments(), 4, rightNames, 0, amount);
            return new Admin(id, guid, username, "", Right.parseRights(rightNames));
        }
        return null;
    }

    public boolean setAdminRights(int id, EnumSet<Right> rights) throws IOException {
        String[] args = new String[rights.size() + 2];
        int i = 0;
        args[i++] = String.valueOf(id);
        args[i++] = String.valueOf(rights.size());
        for (Right r : rights) {
            args[i++] = r.name();
        }
        Command response = this.request("admins.setRights", args);
        return response.getName().equals("OK") && response.getInt(0) == rights.size();
    }

    public boolean setAdminPassword(int id, String password) throws IOException {
        Command response = this.request("admins.setPassword", String.valueOf(id), password);
        return response.getName().equals("OK");
    }

    public boolean editAdmin(Admin admin) throws IOException {
        Command response = this.request("admins.edit", String.valueOf(admin.getId()), admin.getGuid());
        return response.getName().equals("OK");
    }

    public ArrayList<Player> searchPlayers(String text, int offset, int limit) throws IOException {
        Command response = this.request("players.search", "partial", text, String.valueOf(offset), String.valueOf(limit));
        if (response.getName().equals("OK")) {
            ArrayList<Player> players = new ArrayList<Player>();
            int i = 0;
            int amount = response.getInt(i++);
            for (int j = 0; j < amount; ++j) {
                int id = response.getInt(i++);
                String name = response.get(i++);
                String guid = response.get(i++);
                String ip = response.get(i++);
                players.add(new Player(id, name, guid, guid, ip));
            }
            return players;
        }
        return null;
    }

    public ArrayList<Punishment> getBansByPartialName(String partial) throws IOException {
        Command response = this.request("bans.list", "partial", partial, "all");
        if (response.getName().equals("OK")) {
            ArrayList<Punishment> bans = new ArrayList<Punishment>();
            int i = 0;
            int amount = response.getInt(i++);
            for (int j = 0; j < amount; ++j) {
                int id = response.getInt(i++);
                String name = response.get(i++);
                String guid = response.get(i++);
                PunishmentType type = Enum.valueOf(PunishmentType.class, response.get(i++));
                int start = response.getInt(i++);
                int end = response.getInt(i++);
                String reason = response.get(i++);
                int issuerId = response.getInt(i++);
                String issuerName = response.get(i++);
                boolean enabled = response.get(i++).equals("true");
                Admin issuer = new Admin(issuerId, "", issuerName, "", EnumSet.noneOf(Right.class));
                bans.add(new Punishment(name, guid, guid, type, start, end, reason, issuer, enabled));
            }
            return bans;
        }
        return null;
    }
}

