/*
 * Decompiled with CFR 0.152.
 */
package rcon.client.swing.admin;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.EnumSet;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import rcon.client.swing.DaemonConnection;
import rcon.client.swing.admin.AdminPane;
import rcon.client.swing.admin.ChangeGuidDialog;
import rcon.client.swing.admin.ChangePasswordDialog;
import rcon.client.swing.admin.RightsDialog;
import rcon.players.Admin;
import rcon.players.Right;

class AdminInformationPanel
extends JPanel
implements ActionListener {
    private final AdminPane adminPane;
    private Admin admin;
    private JButton rights;
    private JButton changePassword;
    private JButton changeGuid;
    private DaemonConnection daemon;

    public AdminInformationPanel(AdminPane adminPane, DaemonConnection daemon, Admin admin) {
        this.adminPane = adminPane;
        this.daemon = daemon;
        this.admin = admin;
        this.setLayout(new BoxLayout(this, 1));
        JLabel c = new JLabel("Admin ID: " + admin.getId());
        this.add(c);
        c.setAlignmentX(0.0f);
        c = new JLabel("User name: " + admin.getUserName());
        this.add(c);
        c.setAlignmentX(0.0f);
        c = new JLabel("GUID: " + admin.getGuid());
        this.add(c);
        c.setAlignmentX(0.0f);
        this.rights = new JButton("Manage rights");
        this.add(this.rights);
        this.rights.setAlignmentX(0.0f);
        this.changePassword = new JButton("Change password");
        this.add(this.changePassword);
        this.changePassword.setAlignmentX(0.0f);
        this.changeGuid = new JButton("Change guid");
        this.add(this.changeGuid);
        this.changeGuid.setAlignmentX(0.0f);
        this.changePassword.addActionListener(this);
        this.rights.addActionListener(this);
        this.changeGuid.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        block17: {
            if (e.getSource() == this.rights) {
                RightsDialog dialog = new RightsDialog(this.admin.getRights());
                dialog.setVisible(true);
                if (dialog.isSubmitted()) {
                    EnumSet<Right> rights = dialog.getRights();
                    try {
                        if (this.daemon.setAdminRights(this.admin.getId(), rights)) {
                            this.admin.setRights(rights);
                            break block17;
                        }
                        JOptionPane.showMessageDialog(null, "Failed to apply admin rights.");
                        this.adminPane.refreshInfo();
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(null, "Failed to apply admin rights.");
                    }
                }
            } else if (e.getSource() == this.changePassword) {
                ChangePasswordDialog dialog = new ChangePasswordDialog();
                dialog.setVisible(true);
                if (dialog.isSubmitted()) {
                    String password = dialog.getPassword();
                    try {
                        if (!this.daemon.setAdminPassword(this.admin.getId(), password)) {
                            JOptionPane.showMessageDialog(null, "Failed to change password.");
                            break block17;
                        }
                        this.adminPane.refreshInfo();
                    }
                    catch (IOException e1) {
                        JOptionPane.showMessageDialog(null, "Failed to change password.");
                    }
                }
            } else if (e.getSource() == this.changeGuid) {
                ChangeGuidDialog dialog = new ChangeGuidDialog(this.daemon);
                dialog.setVisible(true);
                if (dialog.isSubmitted()) {
                    this.admin.setGuid(dialog.getGuid());
                    try {
                        if (!this.daemon.editAdmin(this.admin)) {
                            JOptionPane.showMessageDialog(null, "Could not change GUID.");
                        }
                    }
                    catch (IOException e1) {
                        JOptionPane.showMessageDialog(null, "Could not change GUID.");
                    }
                    this.adminPane.refreshInfo();
                }
            }
        }
    }
}

