/*
 * Decompiled with CFR 0.152.
 */
package rcon.client.swing.admin;

import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import rcon.client.swing.DaemonConnection;
import rcon.client.swing.PlayerSearchDialog;
import rcon.players.Player;

public class RegisterAdminDialog
extends JDialog
implements ActionListener {
    private JTextField username;
    private JPasswordField pw1;
    private JPasswordField pw2;
    private JTextField guid;
    private JButton ok;
    private JButton cancel;
    private boolean submitted;
    private JButton find;
    private DaemonConnection daemon;

    public RegisterAdminDialog(DaemonConnection daemon) {
        super((Dialog)null, "Register admin", true);
        this.daemon = daemon;
        this.setLayout(new GridLayout(6, 2));
        this.add(new JLabel("User name:"));
        this.username = new JTextField();
        this.add(this.username);
        this.add(new JLabel("Password:"));
        this.pw1 = new JPasswordField();
        this.add(this.pw1);
        this.add(new JLabel("Repeat password:"));
        this.pw2 = new JPasswordField();
        this.add(this.pw2);
        this.add(new JLabel("GUID:"));
        this.guid = new JTextField();
        this.add(this.guid);
        this.add(new JPanel());
        this.find = new JButton("Find...");
        this.add(this.find);
        this.ok = new JButton("Ok");
        this.add(this.ok);
        this.cancel = new JButton("Cancel");
        this.add(this.cancel);
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        this.find.addActionListener(this);
        this.getRootPane().setDefaultButton(this.ok);
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent ce) {
                RegisterAdminDialog.this.username.requestFocusInWindow();
            }
        });
        this.pack();
    }

    public void setVisible(boolean b) {
        if (b) {
            this.submitted = false;
        }
        super.setVisible(b);
    }

    public boolean isSubmitted() {
        return this.submitted;
    }

    public String getUsername() {
        return this.username.getText();
    }

    public String getPassword() {
        return new String(this.pw1.getPassword());
    }

    public String getGuid() {
        return this.guid.getText();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ok) {
            if (this.username.getText().isEmpty()) {
                JOptionPane.showMessageDialog(this, "Please enter a user name.");
                this.username.requestFocusInWindow();
            } else if (this.pw1.getPassword().length == 0) {
                JOptionPane.showMessageDialog(this, "Please enter a password.");
                this.pw1.requestFocusInWindow();
            } else if (!Arrays.equals(this.pw1.getPassword(), this.pw2.getPassword())) {
                JOptionPane.showMessageDialog(this, "Passwords do not match.");
                this.pw1.requestFocusInWindow();
            } else {
                this.submitted = true;
                this.setVisible(false);
            }
        } else if (e.getSource() == this.cancel) {
            this.submitted = false;
            this.setVisible(false);
        } else if (e.getSource() == this.find) {
            Player p;
            PlayerSearchDialog search = new PlayerSearchDialog(this.daemon);
            search.setVisible(true);
            if (search.isSubmitted() && (p = search.getPlayer()) != null) {
                this.guid.setText(p.getPbGuid());
            }
        }
    }
}

