/*
 * Decompiled with CFR 0.152.
 */
package rcon.client.swing.ban;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import rcon.client.swing.DaemonConnection;
import rcon.client.swing.ban.BanTable;
import rcon.players.Punishment;

public class BanSearchPane
extends JPanel
implements ActionListener,
DocumentListener {
    private DaemonConnection daemon;
    private Timer refreshTimer;
    private String current;
    private JTextField search;
    private BanTable table;

    public BanSearchPane(DaemonConnection daemon) {
        this.daemon = daemon;
        this.refreshTimer = new Timer(500, this);
        this.refreshTimer.setRepeats(false);
        this.current = "";
        this.setLayout(new BorderLayout());
        this.search = new JTextField();
        this.add((Component)this.search, "North");
        this.table = new BanTable();
        this.add((Component)new JScrollPane(this.table), "Center");
        this.search.getDocument().addDocumentListener(this);
    }

    public boolean requestFocusInWindow() {
        return this.search.requestFocusInWindow();
    }

    public Punishment getSelectedBan() {
        return this.table.getSelectedBan();
    }

    private void refresh() {
        try {
            this.current = this.search.getText();
            this.table.setBans(this.daemon.getBansByPartialName(this.current));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.refreshTimer && !this.search.getText().equals(this.current) && this.search.getText().length() >= 3) {
            this.refresh();
        }
    }

    public void changedUpdate(DocumentEvent arg0) {
        this.refreshTimer.restart();
    }

    public void insertUpdate(DocumentEvent arg0) {
        this.refreshTimer.restart();
    }

    public void removeUpdate(DocumentEvent arg0) {
        this.refreshTimer.restart();
    }
}

