/*
 * Decompiled with CFR 0.152.
 */
package rcon.net;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import rcon.MessageType;
import rcon.commands.Command;

public class RCONOutputStream {
    static Logger logger = Logger.getLogger(RCONOutputStream.class);
    private ByteArrayOutputStream bout = new ByteArrayOutputStream();
    private OutputStream out;

    public RCONOutputStream(OutputStream out) {
        this.out = new BufferedOutputStream(out);
    }

    private void writeWord(String string) throws IOException {
        this.writeInt(this.bout, string.length());
        this.bout.write(string.getBytes("US-ASCII"));
        this.bout.write(0);
    }

    public synchronized void sendCommand(Command command) throws IOException {
        int words = command.size() + 1;
        this.writeInt(this.bout, words);
        this.writeWord(command.getName());
        for (String argument : command.getArguments()) {
            this.writeWord(argument);
        }
        this.writeHeader(command.getSeq(), command.getType());
        this.out.flush();
        this.bout.reset();
        logger.trace("-> " + command);
    }

    private void writeHeader(int sequence, MessageType type) throws IOException {
        this.writeInt(this.out, (long)sequence | type.flags);
        this.writeInt(this.out, this.bout.size() + 4 + 4);
        this.out.write(this.bout.toByteArray());
    }

    private void writeInt(OutputStream out, long value) throws IOException {
        out.write((int)(value & 0xFFL));
        out.write((int)((value & 0xFF00L) >> 8));
        out.write((int)((value & 0xFF0000L) >> 16));
        out.write((int)((value & 0xFF000000L) >> 24));
    }
}

