/*
 * Decompiled with CFR 0.152.
 */
package rcon.players;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import rcon.database.Database;
import rcon.database.DatabaseModule;
import rcon.players.Admin;
import rcon.players.Right;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminDatabase
extends DatabaseModule {
    public AdminDatabase(Database database, String id) {
        super(database, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Admin get(String username) throws SQLException {
        ResultSet result;
        PreparedStatement stmt;
        Connection con;
        block3: {
            Admin admin;
            con = this.getConnection();
            stmt = null;
            result = null;
            try {
                stmt = con.prepareStatement("SELECT * FROM admins WHERE username = ?");
                stmt.setString(1, username);
                result = stmt.executeQuery();
                if (!result.next()) break block3;
                admin = this.parse(result);
            }
            catch (Throwable throwable) {
                this.close(con, stmt, result);
                throw throwable;
            }
            this.close(con, stmt, result);
            return admin;
        }
        Admin admin = null;
        this.close(con, stmt, result);
        return admin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Admin get(int id) throws SQLException {
        ResultSet result;
        PreparedStatement stmt;
        Connection con;
        block3: {
            Admin admin;
            con = this.getConnection();
            stmt = null;
            result = null;
            try {
                stmt = con.prepareStatement("SELECT * FROM admins WHERE id = ?");
                stmt.setInt(1, id);
                result = stmt.executeQuery();
                if (!result.next()) break block3;
                admin = this.parse(result);
            }
            catch (Throwable throwable) {
                this.close(con, stmt, result);
                throw throwable;
            }
            this.close(con, stmt, result);
            return admin;
        }
        Admin admin = null;
        this.close(con, stmt, result);
        return admin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Admin getByGuid(String guid) throws SQLException {
        ResultSet result;
        PreparedStatement stmt;
        Connection con;
        block3: {
            Admin admin;
            con = this.getConnection();
            stmt = null;
            result = null;
            try {
                stmt = con.prepareStatement("SELECT * FROM admins WHERE guid = ?");
                stmt.setString(1, guid);
                result = stmt.executeQuery();
                if (!result.next()) break block3;
                admin = this.parse(result);
            }
            catch (Throwable throwable) {
                this.close(con, stmt, result);
                throw throwable;
            }
            this.close(con, stmt, result);
            return admin;
        }
        Admin admin = null;
        this.close(con, stmt, result);
        return admin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save(Admin admin) throws SQLException {
        Connection con = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement("UPDATE admins SET guid = ?, username = ?, password = ?, rights = ? WHERE id = ?");
            stmt.setString(1, admin.getGuid());
            stmt.setString(2, admin.getUserName());
            stmt.setString(3, admin.getPassword());
            stmt.setString(4, Right.toString(admin.getRights()));
            stmt.setInt(5, admin.getId());
            boolean bl = stmt.executeUpdate() == 1;
            return bl;
        }
        finally {
            this.close(con, stmt, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean create(Admin admin) throws SQLException {
        ResultSet keys;
        PreparedStatement stmt;
        Connection con;
        block3: {
            boolean bl;
            con = this.getConnection();
            stmt = null;
            keys = null;
            try {
                stmt = con.prepareStatement("INSERT INTO admins (guid, username, password, rights) VALUES(?, ?, ?, ?)", 1);
                stmt.setString(1, admin.getGuid());
                stmt.setString(2, admin.getUserName());
                stmt.setString(3, admin.getPassword());
                stmt.setString(4, Right.toString(admin.getRights()));
                if (stmt.executeUpdate() != 1 || !(keys = stmt.getGeneratedKeys()).next()) break block3;
                int id = keys.getInt(1);
                admin.setId(id);
                bl = true;
            }
            catch (Throwable throwable) {
                this.close(con, stmt, keys);
                throw throwable;
            }
            this.close(con, stmt, keys);
            return bl;
        }
        boolean bl = false;
        this.close(con, stmt, keys);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Admin> getAll() throws SQLException {
        ArrayList<Admin> arrayList;
        Connection con = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement("SELECT * FROM admins");
            ArrayList<Admin> admins = new ArrayList<Admin>();
            result = stmt.executeQuery();
            while (result.next()) {
                admins.add(this.parse(result));
            }
            arrayList = admins;
        }
        catch (Throwable throwable) {
            this.close(con, stmt, result);
            throw throwable;
        }
        this.close(con, stmt, result);
        return arrayList;
    }

    public Admin parse(ResultSet result) throws SQLException {
        int adminId = result.getInt("admins.id");
        String adminGuid = result.getString("admins.guid");
        String adminUsername = result.getString("admins.username");
        String adminPassword = result.getString("admins.password");
        String rightsString = result.getString("admins.rights");
        String[] rights = rightsString.split(" ");
        Admin admin = new Admin(adminId, adminGuid, adminUsername, adminPassword, Right.parseRights(rights));
        return admin;
    }
}

