/*
 * Decompiled with CFR 0.152.
 */
package rcon.players;

import java.util.Calendar;
import rcon.players.Admin;
import rcon.players.PlayerInfo;
import rcon.players.Report;

public class Player {
    private final String name;
    private String pbGuid;
    private String ip;
    private int id;
    private Admin admin;
    private PlayerInfo info;
    private long lastUpdate;
    private long created;
    private int killStreak;
    private boolean hasSpawned;
    private Report activeReport;

    public Player(String name) {
        this.name = name;
        this.pbGuid = "";
        this.ip = "";
        this.id = 0;
        this.admin = null;
        this.info = new PlayerInfo();
        this.lastUpdate = 0L;
        this.created = Calendar.getInstance().getTimeInMillis() / 1000L;
        this.killStreak = 0;
        this.hasSpawned = false;
        this.activeReport = null;
    }

    public Player(int id, String name, String eaGuid, String pbGuid, String ip) {
        this(name);
        this.pbGuid = pbGuid;
        this.ip = ip;
        this.id = id;
        this.info = new PlayerInfo(name, eaGuid);
    }

    public String getName() {
        return this.name;
    }

    public synchronized String getFullName() {
        return this.info.getClanTag().isEmpty() ? this.name : this.info.getClanTag() + " " + this.name;
    }

    public synchronized String getTag() {
        return this.info.getClanTag();
    }

    public synchronized String getPbGuid() {
        return this.pbGuid;
    }

    public synchronized void setPbGuid(String pbGuid) {
        this.pbGuid = pbGuid;
    }

    public synchronized String getIp() {
        return this.ip;
    }

    public synchronized void setIp(String ip) {
        this.ip = ip;
    }

    public synchronized int getId() {
        return this.id;
    }

    public synchronized void setId(int id) {
        this.id = id;
    }

    public synchronized Admin getAdmin() {
        return this.admin;
    }

    public synchronized void setAdmin(Admin admin) {
        this.admin = admin;
    }

    public synchronized boolean isAdmin() {
        return this.admin != null;
    }

    public synchronized void update(PlayerInfo info) {
        if (!this.name.equals(info.getName())) {
            throw new IllegalArgumentException("Player info does not match player.");
        }
        this.info = info;
    }

    public synchronized String getEaGuid() {
        return this.info.getEaGuid();
    }

    public synchronized void setEaGuid(String eaGuid) {
        this.info = this.info.eaGuid(eaGuid);
    }

    public synchronized String toString() {
        return this.getFullName() + ": " + this.getEaGuid() + ", " + this.getPbGuid() + ", " + this.getIp() + ".";
    }

    public synchronized PlayerInfo getInfo() {
        return this.info;
    }

    public synchronized void onUpdated() {
        this.lastUpdate = System.currentTimeMillis();
    }

    public synchronized long getLastUpdate() {
        return this.lastUpdate;
    }

    public synchronized long getCreated() {
        return this.created;
    }

    public synchronized int incrementStreak() {
        return ++this.killStreak;
    }

    public synchronized void resetStreak() {
        this.killStreak = 0;
    }

    public synchronized int getKillStreak() {
        return this.killStreak;
    }

    public synchronized void spawn() {
        this.hasSpawned = true;
    }

    public synchronized boolean hasSpawned() {
        return this.hasSpawned;
    }

    public synchronized Report getActiveReport() {
        return this.activeReport;
    }

    public synchronized void setActiveReport(Report activeReport) {
        this.activeReport = activeReport;
    }
}

