/*
 * Decompiled with CFR 0.152.
 */
package rcon.players;

import rcon.players.Admin;
import rcon.players.Player;
import rcon.players.PunishmentType;

public class Punishment {
    private String name;
    private String eaguid;
    private PunishmentType type;
    private long start;
    private long end;
    private String reason;
    private Admin issuer;
    private int id;
    private boolean enabled;
    private String pbguid;

    public Punishment(String name, String eaguid, String pbguid, PunishmentType type, long start, long end, String reason, Admin issuer, boolean enabled) {
        this.name = name;
        this.eaguid = eaguid;
        this.pbguid = pbguid;
        this.type = type;
        this.start = start;
        this.end = end;
        this.reason = reason;
        this.issuer = issuer;
        this.enabled = enabled;
    }

    public static Punishment ban(Player player, long time, String reason, Admin issuer) {
        long start = System.currentTimeMillis() / 1000L;
        long end = time == 0L ? 0L : start + time;
        String name = player.getName();
        String eaGuid = player.getEaGuid();
        String pbGuid = player.getPbGuid();
        PunishmentType type = PunishmentType.ban;
        return new Punishment(name, eaGuid, pbGuid, type, start, end, reason, issuer, true);
    }

    public static Punishment kick(Player player, String reason, Admin issuer) {
        long start = System.currentTimeMillis() / 1000L;
        String name = player.getName();
        String eaGuid = player.getEaGuid();
        String pbGuid = player.getPbGuid();
        PunishmentType type = PunishmentType.kick;
        return new Punishment(name, eaGuid, pbGuid, type, start, 0L, reason, issuer, true);
    }

    public static Punishment warn(Player player, String reason, Admin issuer) {
        long start = System.currentTimeMillis() / 1000L;
        String name = player.getName();
        String eaGuid = player.getEaGuid();
        String pbGuid = player.getPbGuid();
        PunishmentType type = PunishmentType.warn;
        return new Punishment(name, eaGuid, pbGuid, type, start, 0L, reason, issuer, true);
    }

    public int getId() {
        return this.id;
    }

    protected void setId(int id) {
        this.id = id;
    }

    public String getPbGuid() {
        return this.pbguid;
    }

    public String getName() {
        return this.name;
    }

    public PunishmentType getType() {
        return this.type;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public String getReason() {
        return this.reason;
    }

    public Admin getIssuer() {
        return this.issuer;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPbGuid(String guid) {
        this.pbguid = guid;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getEaGuid() {
        return this.eaguid;
    }

    public void setEaGuid(String guid) {
        this.eaguid = guid;
    }
}

