/*
 * Decompiled with CFR 0.152.
 */
package rcon.server;

import rcon.server.Configuration;
import rcon.server.GameServer;

public class ConfigSynchronizer
implements Runnable {
    private volatile boolean enabled;
    private GameServer server;

    public ConfigSynchronizer(GameServer server) {
        this.server = server;
        this.enabled = true;
    }

    public void run() {
        if (!this.enabled) {
            throw new IllegalStateException("Configuration synchronization is disabled.");
        }
        Configuration config = this.server.getConfiguration();
        for (Configuration.Variable var : Configuration.Variable.values()) {
            String currentValue = this.server.getVariable("vars." + var.getName());
            if (currentValue == null || currentValue.equals(config.get(var))) continue;
            if (config.isEnforced(var)) {
                boolean ret = this.server.setVariable("vars." + var.getName(), config.get(var));
                if (ret) continue;
            }
            config.update(var, currentValue);
        }
    }

    public void stop() {
        this.enabled = false;
    }
}

