/*
 * Decompiled with CFR 0.152.
 */
package rcon.server;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import rcon.commands.Command;
import rcon.event.RCONEventHandler;
import rcon.players.Player;
import rcon.players.PlayerInfo;
import rcon.server.OnlineList;
import rcon.server.ServerConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventParser
extends Thread {
    static Logger logger = Logger.getLogger(EventParser.class);
    public static final String pListRegex = "^.*PunkBuster Server:\\s+(\\d+)\\s+([0-9a-f]+)\\(-\\)\\s+([0-9\\.]+):(\\d+)\\s+[^\"]+\"([^\"]+)\"\\s*$";
    private static final Pattern pListPattern = Pattern.compile("^.*PunkBuster Server:\\s+(\\d+)\\s+([0-9a-f]+)\\(-\\)\\s+([0-9\\.]+):(\\d+)\\s+[^\"]+\"([^\"]+)\"\\s*$");
    public static final String guidRegex = "^.*PunkBuster Server: Player GUID Computed\\s+([0-9a-f]+)\\(-\\)\\s+\\(slot #(\\d+)\\)\\s+([0-9\\.]+):(\\d+)\\s+(.+)\\s*$";
    private static final Pattern guidPattern = Pattern.compile("^.*PunkBuster Server: Player GUID Computed\\s+([0-9a-f]+)\\(-\\)\\s+\\(slot #(\\d+)\\)\\s+([0-9\\.]+):(\\d+)\\s+(.+)\\s*$");
    private final ArrayList<RCONEventHandler> handlers = new ArrayList();
    private final ServerConnection connection;
    private final OnlineList online;

    public EventParser(OnlineList online, ServerConnection connection) {
        super("EventParser");
        this.online = online;
        this.connection = connection;
    }

    @Override
    public void run() {
        while (true) {
            try {
                Command event;
                while ((event = this.connection.getEvent()) != Command.EOF) {
                    Object info;
                    String cmd = event.getName();
                    String[] args = event.getArguments();
                    if (cmd.equals("player.onJoin")) {
                        this.onJoin(args[0], args[1]);
                        continue;
                    }
                    if (cmd.equals("player.onLeave")) {
                        info = PlayerInfo.parseSingle(event);
                        this.onLeave(args[0], (PlayerInfo)info);
                        continue;
                    }
                    if (cmd.equals("player.onKill")) {
                        String killer = args[0];
                        String killed = args[1];
                        String weapon = args[2];
                        String headshot = args[3];
                        boolean hs = Boolean.valueOf(headshot);
                        this.onKill(killer, killed, weapon, hs);
                        continue;
                    }
                    if (cmd.equals("player.onChat")) {
                        this.onChat(args[0], args[1]);
                        continue;
                    }
                    if (cmd.equals("punkBuster.onMessage")) {
                        this.onPunkbuster(args[0]);
                        continue;
                    }
                    if (cmd.equals("player.onAuthenticated")) {
                        this.onAuthenticated(args[0]);
                        continue;
                    }
                    if (cmd.equals("player.onTeamChange")) {
                        this.onTeamChange(args[0], args[1], args[2]);
                        continue;
                    }
                    if (cmd.equals("player.onSquadChange")) {
                        this.onSquadChange(args[0], args[1], args[2]);
                        continue;
                    }
                    if (cmd.equals("player.onKicked")) {
                        this.onKicked(args[0], args[1]);
                        continue;
                    }
                    if (cmd.equals("server.onLevelLoaded")) {
                        String levelName = args[0];
                        String gameMode = args[1];
                        int roundsPlayed = Integer.parseInt(args[1]);
                        int roundsTotal = Integer.parseInt(args[2]);
                        this.onLevelLoaded(levelName, gameMode, roundsPlayed, roundsTotal);
                        continue;
                    }
                    if (cmd.equals("player.onSpawn")) {
                        String name = args[0];
                        this.onSpawn(name);
                        continue;
                    }
                    if (cmd.equals("server.onRoundOver")) {
                        String winner = args[0];
                        continue;
                    }
                    if (cmd.equals("server.onRoundOverPlayers")) {
                        info = PlayerInfo.parse(event);
                        this.onRoundOverPlayers((ArrayList<PlayerInfo>)info);
                        continue;
                    }
                    if (cmd.equals("server.onRoundOverTeamScores")) continue;
                    logger.warn("Unknown event notification: " + cmd);
                }
            }
            catch (Exception e) {
                logger.error("Fatal error during event parsing. Ignoring.", e);
                continue;
            }
            break;
        }
        logger.trace("Event parsing stopped.");
    }

    private void onRoundOverPlayers(ArrayList<PlayerInfo> info) {
        for (PlayerInfo i : info) {
            this.onPlayerInfo(i);
        }
        for (RCONEventHandler handler : this.handlers) {
            handler.onRoundOverPlayers(info);
        }
    }

    private void onSpawn(String name) {
        Player p = this.online.getByName(name);
        if (p != null) {
            boolean first = !p.hasSpawned();
            for (RCONEventHandler handler : this.handlers) {
                handler.onSpawn(p, first);
            }
            p.spawn();
        }
    }

    private void onLevelStarted() {
        for (RCONEventHandler handler : this.handlers) {
            handler.onLevelStarted();
        }
    }

    private void onLevelLoaded(String level, String gameMode, int roundsPlayed, int roundsTotal) {
        for (RCONEventHandler handler : this.handlers) {
            handler.onLevelLoaded(level, gameMode, roundsPlayed, roundsTotal);
        }
    }

    private void onSquadChange(String name, String teamId, String squadId) {
        Player p = this.online.getByName(name);
        if (p != null) {
            p.onUpdated();
            int team = Integer.parseInt(teamId);
            int squad = Integer.parseInt(squadId);
            for (RCONEventHandler handler : this.handlers) {
                handler.onSquadChange(p, team, squad);
            }
        }
    }

    private void onTeamChange(String name, String teamId, String squadId) {
        Player p = this.online.getByName(name);
        if (p != null) {
            p.onUpdated();
            int team = Integer.parseInt(teamId);
            int squad = Integer.parseInt(squadId);
            for (RCONEventHandler handler : this.handlers) {
                handler.onTeamChange(p, team, squad);
            }
        }
    }

    private void onKicked(String name, String reason) {
        Player p = this.online.getByName(name);
        if (p != null) {
            p.onUpdated();
            for (RCONEventHandler handler : this.handlers) {
                handler.onKicked(p, reason);
            }
        } else {
            logger.warn("onKicked event for unknown player. " + name + " was kicked for " + reason + ".");
        }
    }

    private void onAuthenticated(String name) {
        Player p = this.online.ensureGetByName(name);
        p.onUpdated();
        for (RCONEventHandler handler : this.handlers) {
            handler.onAuthenticated(p);
        }
    }

    public void addHandler(RCONEventHandler handler) {
        this.handlers.add(handler);
    }

    private void onChat(String name, String text) {
        Player p = this.online.getByName(name);
        if (p != null) {
            p.onUpdated();
            for (RCONEventHandler handler : this.handlers) {
                handler.onChat(p, text);
            }
        } else {
            logger.warn("onChat event for unknown player. " + name + " said \"" + text + "\".");
        }
    }

    private void onJoin(String name, String eaGuid) {
        if (name.trim().length() > 0) {
            Player p = new Player(name);
            p.setEaGuid(eaGuid);
            this.online.addPlayer(p);
            p.onUpdated();
            logger.info("Player " + name + " (EAGUID: " + eaGuid + ") joined the game.");
            for (RCONEventHandler handler : this.handlers) {
                handler.onJoin(p, eaGuid);
            }
        } else {
            logger.warn("Player without a name joined. Ignoring for now.");
        }
    }

    private void onKill(String killerName, String killedName, String weapon, boolean headshot) {
        Player killer = this.online.ensureGetByName(killerName);
        Player killed = this.online.ensureGetByName(killedName);
        if (killer != null && killed != null) {
            killer.onUpdated();
            killed.onUpdated();
            for (RCONEventHandler handler : this.handlers) {
                handler.onKill(killer, killed, weapon, headshot);
            }
        } else {
            logger.warn("onKill event for unknown player. " + killerName + "(" + killer + ") killed " + killedName + "(" + killed + ").");
        }
    }

    private void onLeave(String name, PlayerInfo info) {
        if (info != null) {
            this.onPlayerInfo(info);
        }
        Player p = this.online.ensureGetByName(name);
        p.onUpdated();
        logger.info("Player " + name + " left the game.");
        for (RCONEventHandler handler : this.handlers) {
            handler.onLeave(p, info);
        }
        this.online.removePlayer(p);
    }

    private void onPunkbuster(String message) {
        Player p;
        String name;
        String ip;
        String guid;
        Matcher matcher = pListPattern.matcher(message);
        if (matcher.matches()) {
            guid = matcher.group(2);
            ip = matcher.group(3);
            name = matcher.group(5);
            p = this.syncPlayer(name, guid, ip);
            for (RCONEventHandler handler : this.handlers) {
                handler.onPbInfo(p, guid, ip);
            }
        }
        if ((matcher = guidPattern.matcher(message)).matches()) {
            guid = matcher.group(1);
            ip = matcher.group(3);
            name = matcher.group(5);
            p = this.syncPlayer(name, guid, ip);
            for (RCONEventHandler handler : this.handlers) {
                handler.onPbInfo(p, guid, ip);
            }
        }
        for (RCONEventHandler handler : this.handlers) {
            handler.onPunkbuster(message);
        }
    }

    public void onPlayerInfo(PlayerInfo info) {
        Player p = this.online.ensureGetByName(info.getName());
        p.onUpdated();
        PlayerInfo old = p.getInfo();
        p.update(info);
        for (RCONEventHandler handler : this.handlers) {
            handler.onPlayerInfo(p, old, info);
        }
    }

    private Player syncPlayer(String name, String guid, String ip) {
        Player p = this.online.ensureGetByName(name);
        p.setPbGuid(guid);
        p.setIp(ip);
        return p;
    }
}

